/*
 * Decompiled with CFR 0.152.
 */
package de.retest.recheck.printer;

import de.retest.recheck.printer.DefaultValueFinderProvider;
import de.retest.recheck.printer.Printer;
import de.retest.recheck.printer.TestReplayResultPrinter;
import de.retest.recheck.printer.highlighting.DefaultHighlighter;
import de.retest.recheck.printer.highlighting.HighlightType;
import de.retest.recheck.printer.highlighting.Highlighter;
import de.retest.recheck.report.SuiteReplayResult;
import de.retest.recheck.report.TestReplayResult;
import java.util.stream.Collectors;

public class SuiteReplayResultPrinter
implements Printer<SuiteReplayResult> {
    private final TestReplayResultPrinter delegate;
    private final Highlighter highlighter;

    public SuiteReplayResultPrinter(DefaultValueFinderProvider provider) {
        this(provider, new DefaultHighlighter());
    }

    public SuiteReplayResultPrinter(DefaultValueFinderProvider provider, Highlighter highlighter) {
        this.delegate = new TestReplayResultPrinter(provider, highlighter);
        this.highlighter = highlighter;
    }

    @Override
    public String toString(SuiteReplayResult difference, String indent) {
        return indent + this.createDescription(difference) + "\n" + this.createDifferences(difference, indent + "\t");
    }

    private String createDescription(SuiteReplayResult difference) {
        String name = difference.getName();
        int differences = difference.getDifferencesCount();
        int states = difference.getTestReplayResults().size();
        return String.format(this.highlighter.highlight("Suite '%s' has %d difference(s) in %d test(s):", HighlightType.HEADING_SUITE_RESULTS), name, differences, states);
    }

    private String createDifferences(SuiteReplayResult difference, String indent) {
        return difference.getTestReplayResults().stream().filter(testReplayResult -> !testReplayResult.isEmpty()).map(d -> this.delegate.toString((TestReplayResult)d, indent)).collect(Collectors.joining("\n"));
    }
}

