/*
 * Decompiled with CFR 0.152.
 */
package de.retest.recheck.printer;

import de.retest.recheck.printer.ActionReplayResultPrinter;
import de.retest.recheck.printer.DefaultValueFinderProvider;
import de.retest.recheck.printer.Printer;
import de.retest.recheck.printer.highlighting.DefaultHighlighter;
import de.retest.recheck.printer.highlighting.HighlightType;
import de.retest.recheck.printer.highlighting.Highlighter;
import de.retest.recheck.report.ActionReplayResult;
import de.retest.recheck.report.TestReplayResult;
import de.retest.recheck.ui.DefaultValueFinder;
import java.util.stream.Collectors;

public class TestReplayResultPrinter
implements Printer<TestReplayResult> {
    private final DefaultValueFinderProvider provider;
    private final Highlighter highlighter;

    public TestReplayResultPrinter(DefaultValueFinderProvider provider) {
        this(provider, new DefaultHighlighter());
    }

    public TestReplayResultPrinter(DefaultValueFinderProvider provider, Highlighter highlighter) {
        this.provider = provider;
        this.highlighter = highlighter;
    }

    @Override
    public String toString(TestReplayResult difference, String indent) {
        return indent + this.createDescription(difference) + "\n" + this.createDifferences(difference, indent);
    }

    private String createDescription(TestReplayResult result) {
        String name = this.highlighter.highlight(result.getName(), HighlightType.TESTREPLAYRESULT_NAME);
        int differences = result.getDifferences().size();
        int states = result.getActionReplayResults().size();
        return String.format("Test '%s' has %d difference(s) in %d state(s):", name, differences, states);
    }

    private String createDifferences(TestReplayResult difference, String indent) {
        return difference.getActionReplayResults().stream().filter(this::shouldPrint).map(a -> this.formatAction((ActionReplayResult)a, indent)).collect(Collectors.joining("\n"));
    }

    private boolean shouldPrint(ActionReplayResult actionReplayResult) {
        return actionReplayResult.hasDifferences() || !actionReplayResult.getMetadataDifference().isEmpty();
    }

    private String formatAction(ActionReplayResult result, String indent) {
        DefaultValueFinder finder = this.provider.findForAction(result.getDescription());
        ActionReplayResultPrinter printer = new ActionReplayResultPrinter(finder, this.highlighter);
        return printer.toString(result, indent);
    }
}

