/*
 * Decompiled with CFR 0.152.
 */
package de.retest.recheck.report;

import de.retest.recheck.report.action.ActionReplayData;
import de.retest.recheck.report.action.DifferenceRetriever;
import de.retest.recheck.report.action.WindowRetriever;
import de.retest.recheck.ui.descriptors.Element;
import de.retest.recheck.ui.descriptors.RootElement;
import de.retest.recheck.ui.descriptors.SutState;
import de.retest.recheck.ui.diff.ElementDifference;
import de.retest.recheck.ui.diff.InsertedDeletedElementDifference;
import de.retest.recheck.ui.diff.LeafDifference;
import de.retest.recheck.ui.diff.RootElementDifference;
import de.retest.recheck.ui.diff.StateDifference;
import de.retest.recheck.ui.diff.meta.MetadataDifference;
import de.retest.recheck.ui.image.Screenshot;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlElementWrapper;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

@XmlRootElement(name="action")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class ActionReplayResult
implements Serializable {
    private static final long serialVersionUID = 2L;
    @XmlAttribute
    private final String description;
    private final String goldenMasterPath;
    @XmlElement
    private final Element targetcomponent;
    @XmlElement
    private final StateDifference stateDifference;
    @XmlElement
    private final MetadataDifference metadataDifference;
    @XmlAttribute
    private long duration;
    @XmlElement(name="window")
    @XmlElementWrapper(name="state")
    private final List<RootElement> windows;

    protected ActionReplayResult() {
        this.description = null;
        this.goldenMasterPath = null;
        this.targetcomponent = null;
        this.stateDifference = null;
        this.metadataDifference = MetadataDifference.empty();
        this.windows = null;
    }

    protected ActionReplayResult(ActionReplayData data, WindowRetriever windows, DifferenceRetriever difference, long duration) {
        if (windows.isNull() && difference.isNull()) {
            throw new NullPointerException("ActionReplayResult must not be empty! Affected action: " + data.getDescription() + ".");
        }
        this.description = data.getDescription();
        this.goldenMasterPath = data.getGoldenMasterPath();
        this.targetcomponent = data.getElement();
        this.windows = (List)windows.get();
        this.stateDifference = difference.getStateDifference();
        this.metadataDifference = difference.getMetadataDifference();
        this.duration = duration;
    }

    public static ActionReplayResult createActionReplayResult(ActionReplayData data, StateDifference difference, long actualDuration, SutState actualState) {
        if (difference != null && !difference.getRootElementDifferences().isEmpty()) {
            return ActionReplayResult.withDifference(data, WindowRetriever.empty(), DifferenceRetriever.of(difference), actualDuration);
        }
        return ActionReplayResult.withDifference(data, WindowRetriever.of(actualState), DifferenceRetriever.empty(), actualDuration);
    }

    public static ActionReplayResult withDifference(ActionReplayData data, WindowRetriever windows, DifferenceRetriever difference, long duration) {
        return new ActionReplayResult(data, windows, difference, duration);
    }

    public StateDifference getStateDifference() {
        return this.stateDifference;
    }

    public long getDuration() {
        return this.duration;
    }

    public String getDescription() {
        return this.description;
    }

    public String getGoldenMasterPath() {
        return this.goldenMasterPath;
    }

    public List<ElementDifference> getAllElementDifferences() {
        ArrayList<ElementDifference> differences = new ArrayList<ElementDifference>();
        if (this.stateDifference != null) {
            differences.addAll(this.stateDifference.getNonEmptyDifferences());
        }
        return differences;
    }

    public Set<LeafDifference> getDifferences() {
        HashSet<LeafDifference> result = new HashSet<LeafDifference>();
        for (ElementDifference elementDifference : this.getAllElementDifferences()) {
            result.addAll(elementDifference.getAttributeDifferences());
            LeafDifference identifyingAttributesDifference = elementDifference.getIdentifyingAttributesDifference();
            if (!(identifyingAttributesDifference instanceof InsertedDeletedElementDifference)) continue;
            result.add(identifyingAttributesDifference);
        }
        return result;
    }

    public List<RootElement> getWindows() {
        return this.windows;
    }

    public Element getTargetComponent() {
        return this.targetcomponent;
    }

    public Screenshot getTargetScreenshot() {
        if (this.getTargetComponent() != null) {
            return this.getTargetComponent().getScreenshot();
        }
        return null;
    }

    public int getCheckedUiElementsCount() {
        if (this.hasWindows()) {
            int result = 0;
            for (RootElement rootElement : this.windows) {
                result += rootElement.countAllContainedElements();
            }
            return result;
        }
        if (this.stateDifference != null) {
            int result = 0;
            for (RootElementDifference rootElementDifference : this.stateDifference.getRootElementDifferences()) {
                result += rootElementDifference.getCheckedUiComponentCount();
            }
            return result;
        }
        return 0;
    }

    public boolean hasDifferences() {
        return this.stateDifference != null && this.stateDifference.size() > 0;
    }

    public boolean hasWindows() {
        return this.windows != null && !this.windows.isEmpty();
    }

    public String toString() {
        return "ActionReplayResult('" + this.description + "' resulted in " + this.getAllElementDifferences().size() + " differences.)";
    }

    public MetadataDifference getMetadataDifference() {
        return this.metadataDifference;
    }
}

