/*
 * Decompiled with CFR 0.152.
 */
package de.retest.recheck.report;

import de.retest.recheck.persistence.xml.util.XmlUtil;
import de.retest.recheck.report.ActionReplayResult;
import de.retest.recheck.report.TestReplayResult;
import de.retest.recheck.ui.descriptors.GroundState;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.io.Serializable;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@XmlRootElement(name="suite")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class SuiteReplayResult
implements Serializable {
    private static final long serialVersionUID = 2L;
    private static final Logger logger = LoggerFactory.getLogger(SuiteReplayResult.class);
    @XmlAttribute
    private final String name;
    @XmlAttribute
    private final String testSourceRoot;
    @XmlAttribute
    private final String suiteUuid;
    @XmlAttribute
    private final int suiteNr;
    @XmlElement(name="test")
    private List<TestReplayResult> testReplayResults = new ArrayList<TestReplayResult>();
    @XmlElement
    private long suiteDuration;
    @XmlElement
    private final GroundState execSuiteSutVersion;
    @XmlElement
    private final GroundState replaySutVersion;

    private SuiteReplayResult() {
        this.suiteNr = 0;
        this.testSourceRoot = null;
        this.name = null;
        this.execSuiteSutVersion = null;
        this.replaySutVersion = null;
        this.suiteUuid = null;
    }

    public SuiteReplayResult(String name, int suiteNr, GroundState execSuiteSutVersion, String suiteUuid, GroundState replaySutVersion) {
        this(name, (String)null, suiteNr, execSuiteSutVersion, suiteUuid, replaySutVersion);
    }

    public SuiteReplayResult(String name, Path testSourceRoot, int suiteNr, GroundState execSuiteSutVersion, String suiteUuid, GroundState replaySutVersion) {
        this(name, testSourceRoot != null ? testSourceRoot.toString() : null, suiteNr, execSuiteSutVersion, suiteUuid, replaySutVersion);
    }

    private SuiteReplayResult(String name, String testSourceRoot, int suiteNr, GroundState execSuiteSutVersion, String suiteUuid, GroundState replaySutVersion) {
        this.name = name == null ? "Suite no. " + suiteNr : XmlUtil.clean(name);
        this.testSourceRoot = testSourceRoot;
        if (name == null) {
            logger.info("No suite name given, using {}.", (Object)this.name);
        }
        this.suiteNr = suiteNr;
        this.testReplayResults = new ArrayList<TestReplayResult>();
        this.execSuiteSutVersion = execSuiteSutVersion;
        this.suiteUuid = suiteUuid;
        this.replaySutVersion = replaySutVersion;
    }

    public void addTest(TestReplayResult newReplayResult) {
        this.suiteDuration += newReplayResult.getDuration();
        this.testReplayResults.add(newReplayResult);
    }

    public int getSuiteNr() {
        return this.suiteNr;
    }

    public Optional<Path> getTestSourceRoot() {
        return Optional.ofNullable(this.testSourceRoot).map(x$0 -> Paths.get(x$0, new String[0]));
    }

    public long getDuration() {
        return this.suiteDuration;
    }

    public GroundState getExecSuiteSutVersion() {
        return this.execSuiteSutVersion;
    }

    public String getExecSuiteSutVersionString() {
        if (this.execSuiteSutVersion == null) {
            return "unspecified SUT version";
        }
        return this.execSuiteSutVersion.getSutVersion();
    }

    public GroundState getReplaySutVersion() {
        return this.replaySutVersion;
    }

    public String getReplaySutVersionString() {
        if (this.replaySutVersion == null) {
            return "unspecified SUT version";
        }
        return this.replaySutVersion.getSutVersion();
    }

    public List<TestReplayResult> getTestReplayResults() {
        return Collections.unmodifiableList(this.testReplayResults);
    }

    public int getNumberOfActions() {
        int actionCount = 0;
        for (TestReplayResult testReplayResult : this.testReplayResults) {
            actionCount += testReplayResult.getActionReplayResults().size();
        }
        return actionCount;
    }

    public int getDifferencesCount() {
        int diffsCount = 0;
        for (TestReplayResult testReplayResult : this.testReplayResults) {
            for (ActionReplayResult actionReplayResult : testReplayResult.getActionReplayResults()) {
                diffsCount += actionReplayResult.getAllElementDifferences().size();
            }
        }
        return diffsCount;
    }

    public int getCheckedUiElementsCount() {
        int uiElementsCount = 0;
        for (TestReplayResult testReplayResult : this.testReplayResults) {
            uiElementsCount += testReplayResult.getCheckedUiElementsCount();
        }
        return uiElementsCount;
    }

    public String toString() {
        return "SuiteReplayResult('" + this.getName() + "', Actions: " + this.getNumberOfActions() + ", Checked Elements: " + this.getCheckedUiElementsCount() + ", Differences: " + this.getDifferencesCount() + ")";
    }

    public String getName() {
        return this.name;
    }

    public String getSuiteUuid() {
        return this.suiteUuid;
    }

    public boolean isEmpty() {
        return this.getNumberOfTestsWithChanges() == 0;
    }

    public int getNumberOfTestsWithChanges() {
        int result = 0;
        for (TestReplayResult testReplayResult : this.testReplayResults) {
            if (testReplayResult.isEmpty()) continue;
            ++result;
        }
        return result;
    }
}

