/*
 * Decompiled with CFR 0.152.
 */
package de.retest.recheck.report;

import de.retest.recheck.NoGoldenMasterActionReplayResult;
import de.retest.recheck.persistence.xml.util.XmlUtil;
import de.retest.recheck.report.ActionReplayResult;
import de.retest.recheck.ui.diff.LeafDifference;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@XmlRootElement(name="test")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class TestReplayResult
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(TestReplayResult.class);
    @XmlAttribute
    private final String name;
    @XmlAttribute
    private final int testNr;
    @XmlElement(name="action")
    private List<ActionReplayResult> actionReplayResults;
    @XmlElement
    private long testDuration;

    private TestReplayResult() {
        this.testNr = 0;
        this.name = null;
    }

    public TestReplayResult(String testName, int testNr) {
        String string = this.name = testName == null ? "Test no. " + testNr : XmlUtil.clean(testName);
        if (testName == null) {
            logger.info("No test name given, using {}.", (Object)this.name);
        }
        this.testNr = testNr;
        this.actionReplayResults = new ArrayList<ActionReplayResult>();
    }

    public int getTestNr() {
        return this.testNr;
    }

    public long getDuration() {
        return this.testDuration;
    }

    public void addAction(ActionReplayResult newReplayResult) {
        this.testDuration += newReplayResult.getDuration();
        this.actionReplayResults.add(newReplayResult);
    }

    public String getName() {
        return this.name;
    }

    public List<ActionReplayResult> getActionReplayResults() {
        return Collections.unmodifiableList(this.actionReplayResults);
    }

    public int getCheckedUiElementsCount() {
        int uiElementsCount = 0;
        for (ActionReplayResult actionReplayResult : this.actionReplayResults) {
            uiElementsCount += actionReplayResult.getCheckedUiElementsCount();
        }
        return uiElementsCount;
    }

    public Set<LeafDifference> getDifferences() {
        HashSet<LeafDifference> diffs = new HashSet<LeafDifference>();
        for (ActionReplayResult actionReplayResult : this.actionReplayResults) {
            diffs.addAll(actionReplayResult.getDifferences());
        }
        return diffs;
    }

    public int getDifferencesCount() {
        int differences = 0;
        for (ActionReplayResult actionReplayResult : this.actionReplayResults) {
            differences += actionReplayResult.getAllElementDifferences().size();
        }
        return differences;
    }

    public boolean hasNoGoldenMaster() {
        return this.actionReplayResults.stream().allMatch(NoGoldenMasterActionReplayResult.class::isInstance);
    }

    public String toString() {
        return "TestReplayResult('" + this.getName() + "', Actions: " + this.getActionReplayResults().size() + ", Checked Elements: " + this.getCheckedUiElementsCount() + ", Differences: " + this.getDifferencesCount() + ")";
    }

    public boolean isEmpty() {
        return this.getDifferencesCount() == 0;
    }
}

