/*
 * Decompiled with CFR 0.152.
 */
package de.retest.recheck.report;

import de.retest.recheck.ignore.GloballyIgnoredAttributes;
import de.retest.recheck.persistence.GoldenMasterSourceSuppressDefaultAdapter;
import de.retest.recheck.persistence.Persistable;
import de.retest.recheck.report.SuiteReplayResult;
import de.retest.recheck.ui.review.GoldenMasterSource;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlElementWrapper;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;

@XmlRootElement(name="testreport")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class TestReport
extends Persistable {
    private static final long serialVersionUID = 1L;
    public static final int PERSISTENCE_VERSION = 23;
    @XmlElement(name="suite")
    private final List<SuiteReplayResult> suiteReplayResults = new ArrayList<SuiteReplayResult>();
    @XmlAttribute
    @XmlJavaTypeAdapter(value=GoldenMasterSourceSuppressDefaultAdapter.class)
    private final GoldenMasterSource source;
    @XmlElement
    @XmlElementWrapper(name="ignoredAttributes")
    private final List<String> ignoredAttributes;

    public static TestReport fromApi(SuiteReplayResult newSuite) {
        return new TestReport(GoldenMasterSource.API, newSuite);
    }

    public static TestReport fromApi() {
        return new TestReport(GoldenMasterSource.API);
    }

    public TestReport() {
        this(GoldenMasterSource.RECORDED);
    }

    public TestReport(GoldenMasterSource source) {
        super(23);
        this.source = source;
        this.ignoredAttributes = GloballyIgnoredAttributes.getInstance().getIgnoredAttributesList();
    }

    public TestReport(SuiteReplayResult newSuite) {
        this(GoldenMasterSource.RECORDED, newSuite);
    }

    public TestReport(GoldenMasterSource source, SuiteReplayResult newSuite) {
        this(source);
        this.suiteReplayResults.add(newSuite);
    }

    public void addSuite(SuiteReplayResult newReplayResult) {
        this.suiteReplayResults.add(newReplayResult);
    }

    public List<SuiteReplayResult> getSuiteReplayResults() {
        return Collections.unmodifiableList(this.suiteReplayResults);
    }

    public boolean containsChanges() {
        for (SuiteReplayResult suiteReplayResult : this.suiteReplayResults) {
            if (suiteReplayResult.getDifferencesCount() <= 0) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return "TestReport(Tests: " + this.getNumberOfTests() + ", Actions: " + this.getNumberOfActions() + ", Checked Elements: " + this.getCheckedUiElementsCount() + ", Differences: " + this.getDifferencesCount() + ")";
    }

    public int getNumberOfTests() {
        int testCount = 0;
        for (SuiteReplayResult suiteReplayResult : this.suiteReplayResults) {
            testCount += suiteReplayResult.getTestReplayResults().size();
        }
        return testCount;
    }

    public int getNumberOfActions() {
        int actionsCount = 0;
        for (SuiteReplayResult suiteReplayResult : this.suiteReplayResults) {
            actionsCount += suiteReplayResult.getNumberOfActions();
        }
        return actionsCount;
    }

    public long getDuration() {
        long duration = 0L;
        for (SuiteReplayResult suiteReplayResult : this.suiteReplayResults) {
            duration += suiteReplayResult.getDuration();
        }
        return duration;
    }

    public int getCheckedUiElementsCount() {
        int uiElementsCount = 0;
        for (SuiteReplayResult suiteReplayResult : this.suiteReplayResults) {
            uiElementsCount += suiteReplayResult.getCheckedUiElementsCount();
        }
        return uiElementsCount;
    }

    public int getDifferencesCount() {
        int differences = 0;
        for (SuiteReplayResult suiteReplayResult : this.suiteReplayResults) {
            differences += suiteReplayResult.getDifferencesCount();
        }
        return differences;
    }

    public String getExecSuiteSutVersion() {
        HashSet<String> versions = new HashSet<String>();
        for (SuiteReplayResult suiteReplayResult : this.suiteReplayResults) {
            versions.add(suiteReplayResult.getExecSuiteSutVersionString());
        }
        if (versions.size() == 1) {
            return versions.toArray()[0].toString();
        }
        return ((Object)versions).toString();
    }

    public String getReplaySutVersion() {
        HashSet<String> versions = new HashSet<String>();
        for (SuiteReplayResult suiteReplayResult : this.suiteReplayResults) {
            versions.add(suiteReplayResult.getReplaySutVersionString());
        }
        if (versions.size() == 1) {
            return versions.toArray()[0].toString();
        }
        return ((Object)versions).toString();
    }

    public boolean isEmpty() {
        return this.getNumberOfTestsWithChanges() == 0;
    }

    public int getNumberOfTestsWithChanges() {
        int result = 0;
        for (SuiteReplayResult suiteReplayResult : this.suiteReplayResults) {
            result += suiteReplayResult.getNumberOfTestsWithChanges();
        }
        return result;
    }

    public GoldenMasterSource getGoldenMasterSource() {
        return this.source;
    }
}

