/*
 * Decompiled with CFR 0.152.
 */
package de.retest.recheck.report;

import de.retest.recheck.NoGoldenMasterActionReplayResult;
import de.retest.recheck.ignore.Filter;
import de.retest.recheck.report.ActionReplayResult;
import de.retest.recheck.report.MetadataDifferenceFilter;
import de.retest.recheck.report.SuiteReplayResult;
import de.retest.recheck.report.TestReplayResult;
import de.retest.recheck.report.TestReport;
import de.retest.recheck.report.action.ActionReplayData;
import de.retest.recheck.report.action.DifferenceRetriever;
import de.retest.recheck.ui.descriptors.Element;
import de.retest.recheck.ui.diff.AttributeDifference;
import de.retest.recheck.ui.diff.AttributesDifference;
import de.retest.recheck.ui.diff.ElementDifference;
import de.retest.recheck.ui.diff.IdentifyingAttributesDifference;
import de.retest.recheck.ui.diff.InsertedDeletedElementDifference;
import de.retest.recheck.ui.diff.LeafDifference;
import de.retest.recheck.ui.diff.RootElementDifference;
import de.retest.recheck.ui.diff.StateDifference;
import de.retest.recheck.ui.diff.meta.MetadataDifference;
import de.retest.recheck.util.OptionalUtil;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class TestReportFilter {
    private final MetadataDifferenceFilter metadataDiffFilter = new MetadataDifferenceFilter();
    private final Filter filter;

    public TestReport filter(TestReport report) {
        TestReport newTestReport = new TestReport();
        for (SuiteReplayResult suiteReplayResult : report.getSuiteReplayResults()) {
            newTestReport.addSuite(this.filter(suiteReplayResult));
        }
        return newTestReport;
    }

    public SuiteReplayResult filter(SuiteReplayResult suiteReplayResult) {
        SuiteReplayResult newSuiteReplayResult = new SuiteReplayResult(suiteReplayResult.getName(), suiteReplayResult.getTestSourceRoot().orElse(null), suiteReplayResult.getSuiteNr(), suiteReplayResult.getExecSuiteSutVersion(), suiteReplayResult.getSuiteUuid(), suiteReplayResult.getReplaySutVersion());
        for (TestReplayResult testReplayResult : suiteReplayResult.getTestReplayResults()) {
            newSuiteReplayResult.addTest(this.filter(testReplayResult));
        }
        return newSuiteReplayResult;
    }

    public TestReplayResult filter(TestReplayResult testReplayResult) {
        TestReplayResult newTestReplayResult = new TestReplayResult(testReplayResult.getName(), testReplayResult.getTestNr());
        for (ActionReplayResult actionReplayResult : testReplayResult.getActionReplayResults()) {
            newTestReplayResult.addAction(this.filter(actionReplayResult));
        }
        return newTestReplayResult;
    }

    public ActionReplayResult filter(ActionReplayResult actionReplayResult) {
        if (actionReplayResult instanceof NoGoldenMasterActionReplayResult) {
            return actionReplayResult;
        }
        ActionReplayData data = ActionReplayData.withTarget(actionReplayResult.getDescription(), actionReplayResult.getTargetComponent(), actionReplayResult.getGoldenMasterPath());
        StateDifference newStateDiff = this.filter(actionReplayResult.getStateDifference());
        MetadataDifference newMetadataDiff = this.metadataDiffFilter.filter(actionReplayResult.getMetadataDifference(), this.filter);
        long actualDuration = actionReplayResult.getDuration();
        return ActionReplayResult.withDifference(data, actionReplayResult::getWindows, DifferenceRetriever.of(newStateDiff, newMetadataDiff), actualDuration);
    }

    StateDifference filter(StateDifference stateDiff) {
        if (stateDiff == null || stateDiff.getRootElementDifferences().isEmpty()) {
            return stateDiff;
        }
        List<RootElementDifference> newRootElementDiffs = this.filter(stateDiff.getRootElementDifferences());
        return new StateDifference(newRootElementDiffs);
    }

    List<RootElementDifference> filter(List<RootElementDifference> rootElementDiffs) {
        return rootElementDiffs.stream().map(this::filter).flatMap(OptionalUtil::stream).collect(Collectors.toList());
    }

    Optional<RootElementDifference> filter(RootElementDifference rootElementDiff) {
        return this.filter(rootElementDiff.getElementDifference()).map(newElementDifference -> new RootElementDifference((ElementDifference)newElementDifference, rootElementDiff.getExpectedRootElement(), rootElementDiff.getActualRootElement()));
    }

    Optional<ElementDifference> filter(ElementDifference elementDiff) {
        ElementDifference newElementDiff;
        Element element = elementDiff.getElement();
        AttributesDifference attributesDiff = elementDiff.getAttributesDifference();
        LeafDifference identAttributesDiff = elementDiff.getIdentifyingAttributesDifference();
        Collection<ElementDifference> childDiffs = elementDiff.getChildDifferences();
        if (elementDiff.hasAttributesDifferences()) {
            attributesDiff = this.filter(element, attributesDiff).orElse(null);
        }
        if (elementDiff.hasIdentAttributesDifferences()) {
            identAttributesDiff = this.filter(element, (IdentifyingAttributesDifference)identAttributesDiff).orElse(null);
        } else if (elementDiff.isInsertionOrDeletion()) {
            identAttributesDiff = this.filter((InsertedDeletedElementDifference)identAttributesDiff).orElse(null);
        }
        if (elementDiff.hasChildDifferences()) {
            childDiffs = this.filter(childDiffs);
        }
        boolean anyOwnOrChildDiffs = (newElementDiff = new ElementDifference(element, attributesDiff, identAttributesDiff, elementDiff.getExpectedScreenshot(), elementDiff.getActualScreenshot(), childDiffs)).hasAnyDifference() || newElementDiff.hasChildDifferences();
        return anyOwnOrChildDiffs ? Optional.of(newElementDiff) : Optional.empty();
    }

    Optional<AttributesDifference> filter(Element element, AttributesDifference attributesDiff) {
        return attributesDiff.getDifferences().stream().filter((? super T diff) -> !this.filter.matches(element, (AttributeDifference)diff)).collect(Collectors.collectingAndThen(Collectors.toList(), newDiffs -> newDiffs.isEmpty() ? Optional.empty() : Optional.of(new AttributesDifference((List<AttributeDifference>)newDiffs))));
    }

    Optional<IdentifyingAttributesDifference> filter(Element element, IdentifyingAttributesDifference identAttributesDiff) {
        return identAttributesDiff.getAttributeDifferences().stream().filter((? super T diff) -> !this.filter.matches(element, (AttributeDifference)diff)).collect(Collectors.collectingAndThen(Collectors.toList(), newDiffs -> newDiffs.isEmpty() ? Optional.empty() : Optional.of(new IdentifyingAttributesDifference(element.getIdentifyingAttributes(), (List<AttributeDifference>)newDiffs))));
    }

    Optional<InsertedDeletedElementDifference> filter(InsertedDeletedElementDifference insertedDeletedDiff) {
        if (insertedDeletedDiff.isInserted()) {
            return this.filter.matches(insertedDeletedDiff.getInsertedOrDeletedElement()) || this.filter.matches(insertedDeletedDiff.getInsertedOrDeletedElement(), Filter.ChangeType.INSERTED) ? Optional.empty() : Optional.of(insertedDeletedDiff);
        }
        return this.filter.matches(insertedDeletedDiff.getInsertedOrDeletedElement()) || this.filter.matches(insertedDeletedDiff.getInsertedOrDeletedElement(), Filter.ChangeType.DELETED) ? Optional.empty() : Optional.of(insertedDeletedDiff);
    }

    Collection<ElementDifference> filter(Collection<ElementDifference> elementDiffs) {
        return elementDiffs.stream().map(this::filter).flatMap(OptionalUtil::stream).collect(Collectors.toList());
    }

    public TestReportFilter(Filter filter) {
        this.filter = filter;
    }
}

