/*
 * Decompiled with CFR 0.152.
 */
package de.retest.recheck.review;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import de.retest.recheck.report.ActionReplayResult;
import de.retest.recheck.report.TestReport;
import de.retest.recheck.review.counter.Counter;
import de.retest.recheck.review.counter.NopCounter;
import de.retest.recheck.ui.descriptors.Element;
import de.retest.recheck.ui.descriptors.IdentifyingAttributes;
import de.retest.recheck.ui.diff.AttributeDifference;
import de.retest.recheck.ui.diff.ElementDifference;
import de.retest.recheck.ui.diff.ElementIdentificationWarning;
import de.retest.recheck.ui.diff.InsertedDeletedElementDifference;
import de.retest.recheck.ui.review.ActionChangeSet;
import de.retest.recheck.ui.review.AttributeChanges;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.tuple.ImmutablePair;

public class GlobalChangeSetApplier {
    private final Counter counter;
    private final Multimap<ImmutablePair<String, String>, ActionReplayResult> attributeDiffsLookupMap;
    private final HashMap<ImmutablePair<String, String>, Set<ElementIdentificationWarning>> warningsLookup;
    private final Multimap<String, ActionReplayResult> insertedDiffsLookupMap;
    private final Multimap<String, ActionReplayResult> deletedDiffsLookupMap;
    private final Map<ActionReplayResult, ActionChangeSet> actionChangeSetLookupMap;

    private GlobalChangeSetApplier(TestReport testReport, Counter counter) {
        this.counter = counter;
        this.attributeDiffsLookupMap = ArrayListMultimap.create();
        this.warningsLookup = new HashMap();
        this.insertedDiffsLookupMap = ArrayListMultimap.create();
        this.deletedDiffsLookupMap = ArrayListMultimap.create();
        this.actionChangeSetLookupMap = new HashMap<ActionReplayResult, ActionChangeSet>();
        this.fillReplayResultLookupMaps(testReport);
    }

    public static GlobalChangeSetApplier create(TestReport testReport) {
        return GlobalChangeSetApplier.create(testReport, NopCounter.getInstance());
    }

    public static GlobalChangeSetApplier create(TestReport testReport, Counter counter) {
        return new GlobalChangeSetApplier(testReport, counter);
    }

    private void fillReplayResultLookupMaps(TestReport testReport) {
        testReport.getSuiteReplayResults().stream().flatMap(suiteReplayResult -> suiteReplayResult.getTestReplayResults().stream()).flatMap(testReplayResult -> testReplayResult.getActionReplayResults().stream()).forEach(this::fillReplayResultLookupMaps);
    }

    private void fillReplayResultLookupMaps(ActionReplayResult actionReplayResult) {
        for (ElementDifference elementDiff : actionReplayResult.getAllElementDifferences()) {
            if (elementDiff.isInsertionOrDeletion()) {
                this.fillInsertedDeletedDifferencesLookupMaps(actionReplayResult, elementDiff);
                continue;
            }
            this.fillAttributeDifferencesLookupMap(actionReplayResult, elementDiff);
        }
    }

    private void fillInsertedDeletedDifferencesLookupMaps(ActionReplayResult actionReplayResult, ElementDifference elementDiff) {
        InsertedDeletedElementDifference insertedDeletedElementDiff = (InsertedDeletedElementDifference)elementDiff.getIdentifyingAttributesDifference();
        if (insertedDeletedElementDiff.isInserted()) {
            this.insertedDiffsLookupMap.put((Object)this.identifier(insertedDeletedElementDiff.getActual()), (Object)actionReplayResult);
        } else {
            this.deletedDiffsLookupMap.put((Object)this.identifier(elementDiff.getIdentifyingAttributes()), (Object)actionReplayResult);
        }
    }

    private void fillAttributeDifferencesLookupMap(ActionReplayResult actionReplayResult, ElementDifference elementDiff) {
        IdentifyingAttributes identifyingAttributes = elementDiff.getIdentifyingAttributes();
        for (AttributeDifference attributeDifference : elementDiff.getAttributeDifferences()) {
            ImmutablePair key = ImmutablePair.of((Object)this.identifier(identifyingAttributes), (Object)this.identifier(attributeDifference));
            this.attributeDiffsLookupMap.put((Object)key, (Object)actionReplayResult);
            List<ElementIdentificationWarning> warnings = attributeDifference.getElementIdentificationWarnings();
            if (warnings.isEmpty()) continue;
            this.warningsLookup.computeIfAbsent((ImmutablePair<String, String>)key, k -> new HashSet()).addAll(warnings);
        }
    }

    private Collection<ActionReplayResult> findAllActionResultsWithEqualDifferences(IdentifyingAttributes identifyingAttributes, AttributeDifference attributeDifference) {
        return this.attributeDiffsLookupMap.get((Object)ImmutablePair.of((Object)this.identifier(identifyingAttributes), (Object)this.identifier(attributeDifference)));
    }

    private Set<ElementIdentificationWarning> findAllWarningsForDifference(IdentifyingAttributes attributes, AttributeDifference difference) {
        return this.warningsLookup.getOrDefault(ImmutablePair.of((Object)this.identifier(attributes), (Object)this.identifier(difference)), Collections.emptySet());
    }

    private ActionChangeSet findCorrespondingActionChangeSet(ActionReplayResult actionReplayResult) {
        ActionChangeSet actionChangeSet = this.actionChangeSetLookupMap.get(actionReplayResult);
        assert (actionChangeSet != null) : "Error, introduce() wasn't called for this actionReplayResult!";
        return actionChangeSet;
    }

    public void introduce(ActionReplayResult actionReplayResult, ActionChangeSet actionChangeSet) {
        this.actionChangeSetLookupMap.put(actionReplayResult, actionChangeSet);
    }

    public void addChangeSetForAllEqualIdentAttributeChanges(IdentifyingAttributes identifyingAttributes, AttributeDifference attributeDifference) {
        Collection<ActionReplayResult> actionResultsWithDiffs = this.findAllActionResultsWithEqualDifferences(identifyingAttributes, attributeDifference);
        assert (!actionResultsWithDiffs.isEmpty()) : "Should have been added during load and thus not be empty!";
        for (ActionReplayResult actionReplayResult : actionResultsWithDiffs) {
            ActionChangeSet correspondingActionChangeSet = this.findCorrespondingActionChangeSet(actionReplayResult);
            assert (correspondingActionChangeSet != null) : "Should have been added during load and thus not be empty!";
            AttributeChanges changes = correspondingActionChangeSet.getIdentAttributeChanges();
            changes.add(identifyingAttributes, this.injectWarningsFor(identifyingAttributes, attributeDifference));
        }
        this.counter.add();
    }

    public void createChangeSetForAllEqualAttributesChanges(IdentifyingAttributes identifyingAttributes, AttributeDifference attributeDifference) {
        for (ActionReplayResult actionReplayResult : this.findAllActionResultsWithEqualDifferences(identifyingAttributes, attributeDifference)) {
            ActionChangeSet correspondingActionChangeSet = this.findCorrespondingActionChangeSet(actionReplayResult);
            AttributeChanges changes = correspondingActionChangeSet.getAttributesChanges();
            changes.add(identifyingAttributes, this.injectWarningsFor(identifyingAttributes, attributeDifference));
        }
        this.counter.add();
    }

    public void removeChangeSetForAllEqualIdentAttributeChanges(IdentifyingAttributes identifyingAttributes, AttributeDifference attributeDifference) {
        for (ActionReplayResult actionReplayResult : this.findAllActionResultsWithEqualDifferences(identifyingAttributes, attributeDifference)) {
            ActionChangeSet correspondingActionChangeSet = this.findCorrespondingActionChangeSet(actionReplayResult);
            AttributeChanges changes = correspondingActionChangeSet.getIdentAttributeChanges();
            changes.remove(identifyingAttributes, this.injectWarningsFor(identifyingAttributes, attributeDifference));
        }
        this.counter.remove();
    }

    public void removeChangeSetForAllEqualAttributesChanges(IdentifyingAttributes identifyingAttributes, AttributeDifference attributeDifference) {
        for (ActionReplayResult actionReplayResult : this.findAllActionResultsWithEqualDifferences(identifyingAttributes, attributeDifference)) {
            ActionChangeSet correspondingActionChangeSet = this.findCorrespondingActionChangeSet(actionReplayResult);
            AttributeChanges changes = correspondingActionChangeSet.getAttributesChanges();
            changes.remove(identifyingAttributes, this.injectWarningsFor(identifyingAttributes, attributeDifference));
        }
        this.counter.remove();
    }

    private AttributeDifference injectWarningsFor(IdentifyingAttributes attributes, AttributeDifference difference) {
        AttributeDifference copy = new AttributeDifference(difference.getKey(), difference.getExpected(), difference.getActual());
        copy.addElementIdentificationWarnings(this.findAllWarningsForDifference(attributes, difference));
        return copy;
    }

    public void addChangeSetForAllEqualInsertedChanges(Element inserted) {
        for (ActionReplayResult replayResult : this.insertedDiffsLookupMap.get((Object)this.identifier(inserted))) {
            this.findCorrespondingActionChangeSet(replayResult).addInsertChange(inserted);
        }
        this.counter.add();
    }

    public void addChangeSetForAllEqualDeletedChanges(IdentifyingAttributes deleted) {
        for (ActionReplayResult replayResult : this.deletedDiffsLookupMap.get((Object)this.identifier(deleted))) {
            this.findCorrespondingActionChangeSet(replayResult).addDeletedChange(deleted);
        }
        this.counter.add();
    }

    public void removeChangeSetForAllEqualInsertedChanges(Element inserted) {
        for (ActionReplayResult replayResult : this.insertedDiffsLookupMap.get((Object)this.identifier(inserted))) {
            this.findCorrespondingActionChangeSet(replayResult).removeInsertChange(inserted);
        }
        this.counter.remove();
    }

    public void removeChangeSetForAllEqualDeletedChanges(IdentifyingAttributes deleted) {
        for (ActionReplayResult replayResult : this.deletedDiffsLookupMap.get((Object)this.identifier(deleted))) {
            this.findCorrespondingActionChangeSet(replayResult).removeDeletedChange(deleted);
        }
        this.counter.remove();
    }

    private String identifier(Element element) {
        return this.identifier(element.getIdentifyingAttributes());
    }

    private String identifier(IdentifyingAttributes attributes) {
        return attributes.identifier();
    }

    private String identifier(AttributeDifference difference) {
        return difference.identifier();
    }

    Multimap<ImmutablePair<String, String>, ActionReplayResult> getAttributeDiffsLookupMap() {
        return this.attributeDiffsLookupMap;
    }

    HashMap<ImmutablePair<String, String>, Set<ElementIdentificationWarning>> getWarningsLookup() {
        return this.warningsLookup;
    }

    Multimap<String, ActionReplayResult> getInsertedDiffsLookupMap() {
        return this.insertedDiffsLookupMap;
    }

    Multimap<String, ActionReplayResult> getDeletedDiffsLookupMap() {
        return this.deletedDiffsLookupMap;
    }
}

