/*
 * Decompiled with CFR 0.152.
 */
package de.retest.recheck.review;

import de.retest.recheck.ignore.AllMatchFilter;
import de.retest.recheck.ignore.Filter;
import de.retest.recheck.ignore.PersistentFilter;
import de.retest.recheck.ignore.RecheckIgnoreLocator;
import de.retest.recheck.review.counter.Counter;
import de.retest.recheck.review.ignore.AttributeFilter;
import de.retest.recheck.review.ignore.MatcherFilter;
import de.retest.recheck.review.ignore.matcher.ElementRetestIdMatcher;
import de.retest.recheck.ui.descriptors.Element;
import de.retest.recheck.ui.diff.AttributeDifference;
import de.retest.recheck.util.Predicates;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;

public class GlobalIgnoreApplier
implements Filter {
    private final Counter counter;
    private final List<PersistentFilter> filtered = new ArrayList<PersistentFilter>();
    private final RecheckIgnoreLocator locator;

    private GlobalIgnoreApplier(Counter counter, List<PersistentFilter> filtered) {
        this(counter, filtered, new RecheckIgnoreLocator());
    }

    private GlobalIgnoreApplier(Counter counter, List<PersistentFilter> filtered, RecheckIgnoreLocator locator) {
        this.counter = counter;
        this.filtered.addAll(filtered);
        this.locator = locator;
    }

    public static GlobalIgnoreApplier create(Counter counter) {
        return new GlobalIgnoreApplier(counter, Collections.emptyList());
    }

    public static GlobalIgnoreApplier create(Counter counter, PersistableGlobalIgnoreApplier applier) {
        return new GlobalIgnoreApplier(counter, applier.getIgnores());
    }

    static GlobalIgnoreApplier create(Counter counter, RecheckIgnoreLocator locator) {
        return new GlobalIgnoreApplier(counter, Collections.emptyList(), locator);
    }

    @Override
    public boolean matches(Element element, String attributeKey) {
        return this.any(filter -> filter.matches(element, attributeKey));
    }

    @Override
    public boolean matches(Element element, AttributeDifference difference) {
        return this.any(filter -> filter.matches(element, difference));
    }

    public void ignoreAttribute(Element element, AttributeDifference difference) {
        this.add(new AllMatchFilter(new MatcherFilter(new ElementRetestIdMatcher(element)), new AttributeFilter(difference.getKey())));
    }

    public void unignoreAttribute(Element element, AttributeDifference difference) {
        this.remove(filter -> filter.matches(element, difference));
    }

    @Override
    public boolean matches(Element element) {
        return this.any(filter -> filter.matches(element));
    }

    @Override
    public boolean matches(Element element, Filter.ChangeType change) {
        return this.any(filter -> filter.matches(element, change));
    }

    public void ignoreElement(Element element) {
        this.add(new MatcherFilter(new ElementRetestIdMatcher(element)));
    }

    public void unignoreElement(Element element) {
        this.remove(filter -> filter.matches(element));
    }

    private void add(Filter filter) {
        Path ignorePath = this.locator.getProjectIgnoreFile().orElse(this.locator.getUserIgnoreFile());
        this.filtered.add(new PersistentFilter(ignorePath, filter));
        this.counter.add();
    }

    public void addWithoutCounting(PersistentFilter filter) {
        this.filtered.add(filter);
    }

    private void remove(Predicate<Filter> filter) {
        this.filtered.removeIf(filter);
        this.counter.remove();
    }

    private boolean any(Predicate<Filter> filter) {
        return this.filtered.stream().anyMatch(Predicates.catchExceptionAsFalse(filter));
    }

    public PersistableGlobalIgnoreApplier persist() {
        return new PersistableGlobalIgnoreApplier(this.filtered);
    }

    public static class PersistableGlobalIgnoreApplier {
        private final List<PersistentFilter> filters;

        public PersistableGlobalIgnoreApplier(List<PersistentFilter> filters) {
            this.filters = new ArrayList<PersistentFilter>(filters);
        }

        public List<PersistentFilter> getIgnores() {
            return this.filters;
        }
    }
}

