/*
 * Decompiled with CFR 0.152.
 */
package de.retest.recheck.review.ignore;

import de.retest.recheck.ignore.AllMatchFilter;
import de.retest.recheck.ignore.Filter;
import de.retest.recheck.review.ignore.ChainableFilterLoaderUtil;
import de.retest.recheck.review.ignore.PixelDiffFilter;
import de.retest.recheck.review.ignore.io.InheritanceLoader;
import de.retest.recheck.review.ignore.io.Loader;
import de.retest.recheck.review.ignore.io.RegexLoader;
import de.retest.recheck.ui.descriptors.Element;
import java.util.Arrays;
import java.util.Optional;
import java.util.regex.MatchResult;
import java.util.regex.Pattern;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AttributeFilter
implements Filter {
    private final String attribute;

    public AttributeFilter(String attribute) {
        this.attribute = attribute;
    }

    @Override
    public boolean matches(Element element) {
        return false;
    }

    @Override
    public boolean matches(Element element, String attributeKey) {
        return attributeKey.equals(this.attribute);
    }

    public String toString() {
        return String.format("attribute=%s", this.attribute);
    }

    public static class LegacyAttributeFilterLoader
    extends AttributeFilterLoader {
        public LegacyAttributeFilterLoader() {
            super(Pattern.compile("attribute: (.+)"));
        }
    }

    public static class AttributeFilterLoader
    extends RegexLoader<Filter> {
        private static final Logger log = LoggerFactory.getLogger(AttributeFilterLoader.class);
        public static final Loader<Filter> chainableFilter = new InheritanceLoader<Filter>(Arrays.asList(Pair.of(PixelDiffFilter.class, (Object)new PixelDiffFilter.PixelDiffFilterLoader())));
        private static final String KEY = "attribute=";
        private static final String FORMAT = "attribute=%s";
        private static final Pattern REGEX = Pattern.compile("attribute=(.+)");
        private static final String POSSIBLE_REGEX = "*";

        public AttributeFilterLoader() {
            super(REGEX);
        }

        protected AttributeFilterLoader(Pattern regex) {
            super(regex);
        }

        @Override
        public String save(Filter ignore) {
            if (ignore instanceof AllMatchFilter) {
                return new AllMatchFilter.AllMatchFilterLoader().save((AllMatchFilter)ignore);
            }
            return super.save(ignore);
        }

        @Override
        protected Optional<Filter> load(MatchResult regex) {
            return ChainableFilterLoaderUtil.load(regex, this::loadSimpleAttributeFilter);
        }

        private AttributeFilter loadSimpleAttributeFilter(String attribute) {
            if (attribute.contains(POSSIBLE_REGEX)) {
                String actualLine = KEY + attribute;
                String suggestedLine = "attribute-regex=" + attribute;
                log.warn("'{}' contains '{}'. For regular expressions, please use '{}'.", new Object[]{actualLine, POSSIBLE_REGEX, suggestedLine});
            }
            return new AttributeFilter(attribute.trim());
        }
    }
}

