/*
 * Decompiled with CFR 0.152.
 */
package de.retest.recheck.review.ignore;

import de.retest.recheck.ignore.AllMatchFilter;
import de.retest.recheck.ignore.Filter;
import de.retest.recheck.review.ignore.ChainableFilterLoaderUtil;
import de.retest.recheck.review.ignore.io.RegexLoader;
import de.retest.recheck.ui.descriptors.Element;
import java.util.Optional;
import java.util.regex.MatchResult;
import java.util.regex.Pattern;

public class AttributeRegexFilter
implements Filter {
    private final Pattern attributePattern;

    public AttributeRegexFilter(String attributeRegex) {
        this.attributePattern = Pattern.compile(attributeRegex);
    }

    @Override
    public boolean matches(Element element) {
        return false;
    }

    @Override
    public boolean matches(Element element, String attributeKey) {
        return this.attributePattern.matcher(attributeKey).matches();
    }

    public String toString() {
        return String.format("attribute-regex=%s", this.attributePattern.toString());
    }

    public static class LegacyAttributeRegexFilterLoader
    extends AttributeRegexFilterLoader {
        public LegacyAttributeRegexFilterLoader() {
            super(Pattern.compile("attribute-regex: (.+)"));
        }
    }

    public static class AttributeRegexFilterLoader
    extends RegexLoader<Filter> {
        static final String KEY = "attribute-regex=";
        private static final String FORMAT = "attribute-regex=%s";
        private static final Pattern REGEX = Pattern.compile("attribute-regex=(.+)");

        public AttributeRegexFilterLoader() {
            super(REGEX);
        }

        protected AttributeRegexFilterLoader(Pattern regex) {
            super(regex);
        }

        @Override
        public String save(Filter ignore) {
            if (ignore instanceof AllMatchFilter) {
                return new AllMatchFilter.AllMatchFilterLoader().save((AllMatchFilter)ignore);
            }
            return super.save(ignore);
        }

        @Override
        protected Optional<Filter> load(MatchResult regex) {
            return ChainableFilterLoaderUtil.load(regex, AttributeRegexFilter::new);
        }
    }
}

