/*
 * Decompiled with CFR 0.152.
 */
package de.retest.recheck.review.ignore;

import de.retest.recheck.ignore.AllMatchFilter;
import de.retest.recheck.ignore.Filter;
import de.retest.recheck.review.ignore.ColorDiffFilter;
import de.retest.recheck.review.ignore.PixelDiffFilter;
import de.retest.recheck.review.ignore.ValueRegexFilter;
import de.retest.recheck.review.ignore.io.InheritanceLoader;
import de.retest.recheck.review.ignore.io.Loader;
import java.util.Arrays;
import java.util.Optional;
import java.util.function.Function;
import java.util.regex.MatchResult;
import org.apache.commons.lang3.tuple.Pair;

class ChainableFilterLoaderUtil {
    private static final Loader<Filter> chainableFilter = new InheritanceLoader<Filter>(Arrays.asList(Pair.of(PixelDiffFilter.class, (Object)new PixelDiffFilter.PixelDiffFilterLoader()), Pair.of(ValueRegexFilter.class, (Object)new ValueRegexFilter.ValueRegexFilterLoader()), Pair.of(ColorDiffFilter.class, (Object)new ColorDiffFilter.ColorDiffFilterLoader())));

    ChainableFilterLoaderUtil() {
    }

    public static Optional<Filter> load(MatchResult regex, Function<String, Filter> simpleFilterLoader) {
        return ChainableFilterLoaderUtil.load(regex, simpleFilterLoader, chainableFilter);
    }

    public static Optional<Filter> load(MatchResult regex, Function<String, Filter> simpleFilterLoader, Loader<Filter> chainedFilterLoader) {
        String match = regex.group(1);
        if (!match.contains(",")) {
            return Optional.of(simpleFilterLoader.apply(match));
        }
        String remainder = match.substring(match.indexOf(44) + 1).trim();
        match = match.substring(0, match.indexOf(44));
        Filter chained = chainedFilterLoader.load(remainder).orElseThrow(() -> new IllegalArgumentException("Couldn't find a filter for the expression '" + remainder + "'."));
        return Optional.of(new AllMatchFilter(simpleFilterLoader.apply(match), chained));
    }
}

