/*
 * Decompiled with CFR 0.152.
 */
package de.retest.recheck.review.ignore;

import de.retest.recheck.ignore.Filter;
import de.retest.recheck.review.ignore.io.RegexLoader;
import de.retest.recheck.ui.descriptors.Element;
import de.retest.recheck.ui.diff.AttributeDifference;
import java.awt.Color;
import java.io.Serializable;
import java.util.Optional;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ColorDiffFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(ColorDiffFilter.class);
    private static final Pattern RGB = Pattern.compile("rgb\\((\\d+),\\s?(\\d+),\\s?(\\d+)(,\\s?(\\d+))?\\)");
    private static final double MAX_DISTANCE = 255.0;
    private final String givenInput;
    private final double colorDiff;

    public ColorDiffFilter(String givenInput, double colorDiff) {
        this.givenInput = givenInput;
        this.colorDiff = colorDiff;
    }

    @Override
    public boolean matches(Element element) {
        return false;
    }

    @Override
    public boolean matches(Element element, AttributeDifference attributeDifference) {
        Color expected = ColorDiffFilter.parse(attributeDifference.getExpected());
        Color actual = ColorDiffFilter.parse(attributeDifference.getActual());
        if (expected == null || actual == null) {
            return false;
        }
        double distance = ColorDiffFilter.calculateColorDistance(expected, actual) * 100.0;
        return distance < this.colorDiff;
    }

    static double calculateColorDistance(Color expected, Color actual) {
        double redDiff = Math.abs(expected.getRed() - actual.getRed());
        double greenDiff = Math.abs(expected.getGreen() - actual.getGreen());
        double blueDiff = Math.abs(expected.getBlue() - actual.getBlue());
        double alphaDiff = Math.abs(expected.getAlpha() - actual.getAlpha());
        double distance = Math.min(redDiff + greenDiff + blueDiff + alphaDiff, 255.0);
        return distance / 255.0;
    }

    static Color parse(Serializable input) {
        if (input == null || !(input instanceof String)) {
            return null;
        }
        String color = (String)((Object)input);
        if (color.startsWith("#")) {
            return Color.decode(color);
        }
        Matcher matcher = RGB.matcher(color);
        if (!matcher.find()) {
            return null;
        }
        try {
            String red = matcher.group(1);
            String green = matcher.group(2);
            String blue = matcher.group(3);
            String alpha = matcher.group(5);
            if (alpha != null) {
                return new Color(Math.round(Float.parseFloat(red)), Math.round(Float.parseFloat(green)), Math.round(Float.parseFloat(blue)), Math.round(Float.parseFloat(alpha)));
            }
            return new Color(Math.round(Float.parseFloat(red)), Math.round(Float.parseFloat(green)), Math.round(Float.parseFloat(blue)));
        }
        catch (Exception e) {
            log.debug("Error parsing input {} to color: ", (Object)input, (Object)e);
            return null;
        }
    }

    public String toString() {
        return String.format("color-diff=%s", this.givenInput);
    }

    public String getGivenInput() {
        return this.givenInput;
    }

    public double getColorDiff() {
        return this.colorDiff;
    }

    public static class ColorDiffFilterLoader
    extends RegexLoader<ColorDiffFilter> {
        private static final String KEY = "color-diff=";
        private static final String FORMAT = "color-diff=%s";
        private static final Pattern REGEX = Pattern.compile("color-diff=(\\d+(\\.\\d+)?)(\\%)?");

        public ColorDiffFilterLoader() {
            super(REGEX);
        }

        @Override
        protected Optional<ColorDiffFilter> load(MatchResult regex) {
            String value = regex.group(1);
            double colorDiff = Double.parseDouble(value);
            return Optional.of(new ColorDiffFilter(value, colorDiff));
        }
    }
}

