/*
 * Decompiled with CFR 0.152.
 */
package de.retest.recheck.review.ignore;

import de.retest.recheck.ignore.CompoundFilter;
import de.retest.recheck.ignore.Filter;
import de.retest.recheck.review.ignore.io.Loader;
import de.retest.recheck.ui.descriptors.Element;
import de.retest.recheck.ui.diff.AttributeDifference;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExcludeFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(ExcludeFilter.class);
    private final Filter filter;

    @Override
    public boolean matches(Element element) {
        return !this.filter.matches(element);
    }

    @Override
    public boolean matches(Element element, Filter.ChangeType change) {
        return !this.filter.matches(element, change);
    }

    @Override
    public boolean matches(Element element, String attributeKey) {
        return !this.filter.matches(element, attributeKey);
    }

    @Override
    public boolean matches(Element element, AttributeDifference attributeDifference) {
        return !this.filter.matches(element, attributeDifference);
    }

    public String toString() {
        return String.format("exclude(%s)", this.filter);
    }

    public ExcludeFilter(Filter filter) {
        this.filter = filter;
    }

    Filter getFilter() {
        return this.filter;
    }

    public static class FilterLoader
    implements Loader<ExcludeFilter> {
        private static final String FORMAT = "exclude(%s)";
        private static final Pattern controlRegex = Pattern.compile("^exclude\\((.+?)\\)(?:, exclude\\((.+?)\\))*$");
        private static final Pattern chunkRegex = Pattern.compile("(?:^exclude\\((.+?)\\)(?=, ))|(?:, exclude\\((.+?)\\)(?=, ))|(?:(?:, )?exclude\\((.+?)\\)$)");
        private final Loader<Filter> delegate;

        public FilterLoader(Loader<Filter> delegate) {
            this.delegate = delegate;
        }

        @Override
        public Optional<ExcludeFilter> load(String line) {
            Matcher control = controlRegex.matcher(line);
            if (!control.matches()) {
                return Optional.empty();
            }
            Matcher chunks = chunkRegex.matcher(line);
            ArrayList<Filter> filters = new ArrayList<Filter>();
            while (chunks.find()) {
                String start = chunks.group(1);
                String middle = chunks.group(2);
                String end = chunks.group(3);
                String inner = start != null ? start : (middle != null ? middle : end);
                Optional<Filter> load = this.delegate.load(inner);
                if (load.isPresent()) {
                    filters.add(load.get());
                    continue;
                }
                log.warn("Could not find loader for inner part '{}'.", (Object)inner);
                return Optional.empty();
            }
            return Optional.of(new ExcludeFilter(new CompoundFilter(filters)));
        }

        @Override
        public String save(ExcludeFilter filter) {
            Filter inner = filter.getFilter();
            if (inner instanceof CompoundFilter) {
                List<Filter> filters = ((CompoundFilter)inner).getFilters();
                return filters.stream().map(filter1 -> String.format(FORMAT, this.delegate.save((Filter)filter1))).collect(Collectors.joining(", "));
            }
            return String.format(FORMAT, this.delegate.save(inner));
        }
    }
}

