/*
 * Decompiled with CFR 0.152.
 */
package de.retest.recheck.review.ignore;

import de.retest.recheck.ignore.Filter;
import de.retest.recheck.review.ignore.io.Loader;
import de.retest.recheck.ui.descriptors.Element;
import de.retest.recheck.ui.diff.AttributeDifference;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilterPreserveLineLoader
implements Loader<FilterPreserveLine> {
    private static final Logger log = LoggerFactory.getLogger(FilterPreserveLineLoader.class);

    private boolean canLoad(String line) {
        boolean comment = line.startsWith("#");
        if (comment) {
            return true;
        }
        boolean onlyWhiteSpace = StringUtils.isWhitespace((CharSequence)line);
        if (onlyWhiteSpace) {
            return true;
        }
        boolean leadingWhitespace = Character.isWhitespace(line.charAt(0));
        if (leadingWhitespace) {
            log.warn("Please remove leading whitespace from the following line:\n{}", (Object)line);
            return true;
        }
        return false;
    }

    @Override
    public Optional<FilterPreserveLine> load(String line) {
        if (this.canLoad(line)) {
            return Optional.of(new FilterPreserveLine(line));
        }
        return Optional.empty();
    }

    @Override
    public String save(FilterPreserveLine ignore) {
        return ignore.toString();
    }

    public static class FilterPreserveLine
    implements Filter {
        public static final String COMMENT = "#";
        private final String line;

        public FilterPreserveLine(String line) {
            this.line = line;
        }

        @Override
        public boolean matches(Element element) {
            return false;
        }

        @Override
        public boolean matches(Element element, AttributeDifference attributeDifference) {
            return false;
        }

        public String toString() {
            return this.line;
        }
    }
}

