/*
 * Decompiled with CFR 0.152.
 */
package de.retest.recheck.review.ignore;

import de.retest.recheck.ignore.AllMatchFilter;
import de.retest.recheck.ignore.Filter;
import de.retest.recheck.review.ignore.AttributeFilter;
import de.retest.recheck.review.ignore.AttributeRegexFilter;
import de.retest.recheck.review.ignore.ChainableFilterLoaderUtil;
import de.retest.recheck.review.ignore.DeletedFilter;
import de.retest.recheck.review.ignore.ExcludeFilter;
import de.retest.recheck.review.ignore.ImportedExternalFilter;
import de.retest.recheck.review.ignore.InsertedFilter;
import de.retest.recheck.review.ignore.PixelDiffFilter;
import de.retest.recheck.review.ignore.ValueRegexFilter;
import de.retest.recheck.review.ignore.io.ImportExternalFilterLoader;
import de.retest.recheck.review.ignore.io.InheritanceLoader;
import de.retest.recheck.review.ignore.io.Loader;
import de.retest.recheck.review.ignore.io.Loaders;
import de.retest.recheck.review.ignore.io.RegexLoader;
import de.retest.recheck.review.ignore.matcher.Matcher;
import de.retest.recheck.ui.descriptors.Element;
import java.util.Arrays;
import java.util.Optional;
import java.util.regex.MatchResult;
import java.util.regex.Pattern;
import org.apache.commons.lang3.tuple.Pair;

public class MatcherFilter
implements Filter {
    private final Matcher<Element> matcher;

    public MatcherFilter(Matcher<Element> matcher) {
        this.matcher = matcher;
    }

    @Override
    public boolean matches(Element element) {
        if (this.matcher.test(element)) {
            return true;
        }
        Element parent = element.getParent();
        return parent != null && this.matches(parent);
    }

    public String toString() {
        return "matcher: " + this.matcher.toString();
    }

    public static class MatcherFilterLoader
    extends RegexLoader<Filter> {
        static final String MATCHER = "matcher: ";
        private static final Pattern REGEX = Pattern.compile("matcher: (.+)");
        public static final Loader<Filter> excludeFilters = new InheritanceLoader<Filter>(Arrays.asList(Pair.of(MatcherFilter.class, (Object)new MatcherFilterLoader()), Pair.of(AttributeFilter.class, (Object)new AttributeFilter.AttributeFilterLoader()), Pair.of(AttributeRegexFilter.class, (Object)new AttributeRegexFilter.AttributeRegexFilterLoader()), Pair.of(PixelDiffFilter.class, (Object)new PixelDiffFilter.PixelDiffFilterLoader()), Pair.of(ValueRegexFilter.class, (Object)new ValueRegexFilter.ValueRegexFilterLoader()), Pair.of(InsertedFilter.class, (Object)new InsertedFilter.InsertedFilterLoader()), Pair.of(DeletedFilter.class, (Object)new DeletedFilter.DeletedFilterLoader()), Pair.of(ImportedExternalFilter.class, (Object)new ImportExternalFilterLoader())));
        private static final Loader<Filter> chainableFilter = new InheritanceLoader<Filter>(Arrays.asList(Pair.of(ExcludeFilter.class, (Object)new ExcludeFilter.FilterLoader(excludeFilters)), Pair.of(AttributeFilter.class, (Object)new AttributeFilter.AttributeFilterLoader()), Pair.of(AttributeFilter.class, (Object)new AttributeFilter.LegacyAttributeFilterLoader()), Pair.of(AttributeRegexFilter.class, (Object)new AttributeRegexFilter.AttributeRegexFilterLoader()), Pair.of(AttributeRegexFilter.class, (Object)new AttributeRegexFilter.LegacyAttributeRegexFilterLoader()), Pair.of(PixelDiffFilter.class, (Object)new PixelDiffFilter.PixelDiffFilterLoader()), Pair.of(ValueRegexFilter.class, (Object)new ValueRegexFilter.ValueRegexFilterLoader()), Pair.of(InsertedFilter.class, (Object)new InsertedFilter.InsertedFilterLoader()), Pair.of(DeletedFilter.class, (Object)new DeletedFilter.DeletedFilterLoader())));

        public MatcherFilterLoader() {
            super(REGEX);
        }

        @Override
        public String save(Filter ignore) {
            if (ignore instanceof AllMatchFilter) {
                return new AllMatchFilter.AllMatchFilterLoader().save((AllMatchFilter)ignore);
            }
            return super.save(ignore);
        }

        @Override
        protected Optional<Filter> load(MatchResult regex) {
            return ChainableFilterLoaderUtil.load(regex, match -> new MatcherFilter(Loaders.elementMatcher().load((String)match).orElseThrow(() -> new IllegalArgumentException("Couldn't find a filter for the expression '" + match + "'."))), chainableFilter);
        }
    }
}

