/*
 * Decompiled with CFR 0.152.
 */
package de.retest.recheck.review.ignore;

import de.retest.recheck.ignore.Filter;
import de.retest.recheck.review.ignore.io.RegexLoader;
import de.retest.recheck.ui.descriptors.Element;
import de.retest.recheck.ui.diff.AttributeDifference;
import java.awt.Rectangle;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.regex.MatchResult;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PixelDiffFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(PixelDiffFilter.class);
    private static final String PIXEL = "px";
    private static final Set<String> ignoredKeys = new HashSet<String>(Arrays.asList("style", "box-shadow"));
    private final String givenInput;
    private final double pixelDiff;

    public PixelDiffFilter(String givenInput, double pixelDiff) {
        this.givenInput = givenInput.endsWith(PIXEL) ? givenInput : givenInput + PIXEL;
        this.pixelDiff = pixelDiff;
    }

    @Override
    public boolean matches(Element element) {
        return false;
    }

    @Override
    public boolean matches(Element element, AttributeDifference attributeDifference) {
        Serializable expected = attributeDifference.getExpected();
        Serializable actual = attributeDifference.getActual();
        String key = attributeDifference.getKey();
        if (ignoredKeys.contains(key) || expected == null || actual == null) {
            return false;
        }
        if (expected instanceof Rectangle) {
            return this.checkRectangle((Rectangle)expected, (Rectangle)actual);
        }
        if (expected instanceof String) {
            return this.checkString(key, (String)((Object)expected), (String)((Object)actual));
        }
        return false;
    }

    private boolean checkRectangle(Rectangle expected, Rectangle actual) {
        boolean filterX = (double)Math.abs(expected.x - actual.x) <= this.pixelDiff;
        boolean filterY = (double)Math.abs(expected.y - actual.y) <= this.pixelDiff;
        boolean filterHeight = (double)Math.abs(expected.height - actual.height) <= this.pixelDiff;
        boolean filterWidth = (double)Math.abs(expected.width - actual.width) <= this.pixelDiff;
        return filterX && filterY && filterHeight && filterWidth;
    }

    private boolean checkString(String key, String expected, String actual) {
        String[] actualParts;
        if (!expected.endsWith(PIXEL) || !actual.endsWith(PIXEL)) {
            return false;
        }
        String[] expectedParts = expected.split(" ");
        if (expectedParts.length != (actualParts = actual.split(" ")).length) {
            return false;
        }
        for (int i = 0; i < expectedParts.length; ++i) {
            try {
                double expectedDouble = Double.parseDouble(PixelDiffFilter.clean(expectedParts[i]));
                double actualDouble = Double.parseDouble(PixelDiffFilter.clean(actualParts[i]));
                if (!(Math.abs(expectedDouble - actualDouble) > this.pixelDiff)) continue;
                return false;
            }
            catch (NumberFormatException e) {
                log.error("Could not parse difference with key {}, expected '{}' and actual '{}' for pixel diff.", new Object[]{key, expected, actual});
                return false;
            }
        }
        return true;
    }

    private static String clean(String str) {
        return str.replace(PIXEL, "").replace(",", ".");
    }

    public String toString() {
        return String.format("pixel-diff=%s", this.givenInput);
    }

    public String getGivenInput() {
        return this.givenInput;
    }

    public double getPixelDiff() {
        return this.pixelDiff;
    }

    public static class PixelDiffFilterLoader
    extends RegexLoader<PixelDiffFilter> {
        private static final String KEY = "pixel-diff=";
        private static final String FORMAT = "pixel-diff=%s";
        private static final Pattern REGEX = Pattern.compile("pixel-diff=(\\d+(\\.\\d+)?)(px)?");

        public PixelDiffFilterLoader() {
            super(REGEX);
        }

        @Override
        protected Optional<PixelDiffFilter> load(MatchResult regex) {
            String value = regex.group(1);
            double pixelDiff = Double.parseDouble(value);
            return Optional.of(new PixelDiffFilter(value, pixelDiff));
        }
    }
}

