/*
 * Decompiled with CFR 0.152.
 */
package de.retest.recheck.review.ignore;

import de.retest.recheck.ignore.Filter;
import de.retest.recheck.review.ignore.io.RegexLoader;
import de.retest.recheck.ui.descriptors.Element;
import de.retest.recheck.ui.diff.AttributeDifference;
import java.io.Serializable;
import java.util.Optional;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ValueRegexFilter
implements Filter {
    private final Pattern pattern;

    public ValueRegexFilter(String regex) {
        this.pattern = Pattern.compile(regex);
    }

    @Override
    public boolean matches(Element element) {
        return false;
    }

    @Override
    public boolean matches(Element element, AttributeDifference attributeDifference) {
        Serializable actual = attributeDifference.getActual();
        if (actual == null || !(actual instanceof String)) {
            return false;
        }
        Matcher matcher = this.pattern.matcher((String)((Object)actual));
        return matcher.matches();
    }

    public String toString() {
        return String.format("value-regex=%s", this.pattern);
    }

    public Pattern getPattern() {
        return this.pattern;
    }

    public static class ValueRegexFilterLoader
    extends RegexLoader<ValueRegexFilter> {
        private static final String KEY = "value-regex=";
        private static final String FORMAT = "value-regex=%s";
        private static final Pattern REGEX = Pattern.compile("value-regex=(.+)");

        public ValueRegexFilterLoader() {
            super(REGEX);
        }

        @Override
        protected Optional<ValueRegexFilter> load(MatchResult regex) {
            String value = regex.group(1);
            return Optional.of(new ValueRegexFilter(value));
        }
    }
}

