/*
 * Decompiled with CFR 0.152.
 */
package de.retest.recheck.review.ignore.io;

import de.retest.recheck.review.ignore.FilterPreserveLineLoader;
import de.retest.recheck.review.ignore.io.Loader;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ErrorHandlingLoader
implements Loader<FilterPreserveLineLoader.FilterPreserveLine> {
    private static final Logger logger = LoggerFactory.getLogger(ErrorHandlingLoader.class);

    @Override
    public Optional<FilterPreserveLineLoader.FilterPreserveLine> load(String line) {
        if (line.startsWith("attribute:")) {
            logger.error("For ignoring an attribute globally, please use 'attribute=' (to ensure weired line breaks do not break your ignore file).");
        } else {
            logger.error("No loader defined for line '{}'. Read more at https://docs.retest.de/recheck/how-ignore-works/", (Object)line);
        }
        return Optional.of(new FilterPreserveLineLoader.FilterPreserveLine(line));
    }

    @Override
    public String save(FilterPreserveLineLoader.FilterPreserveLine errorLine) {
        return errorLine.toString();
    }
}

