/*
 * Decompiled with CFR 0.152.
 */
package de.retest.recheck.review.ignore.io;

import de.retest.recheck.ignore.Filter;
import de.retest.recheck.ignore.SearchFilterFiles;
import de.retest.recheck.review.ignore.ImportedExternalFilter;
import de.retest.recheck.review.ignore.io.RegexLoader;
import java.util.Optional;
import java.util.regex.MatchResult;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImportExternalFilterLoader
extends RegexLoader<ImportedExternalFilter> {
    private static final Logger log = LoggerFactory.getLogger(ImportExternalFilterLoader.class);
    public static final String IMPORT_STATEMENT = "import: ";
    public static final String FORMAT = "import: %s";
    private static final Pattern PREFIX = Pattern.compile("import: (.+)");

    public ImportExternalFilterLoader() {
        super(PREFIX);
    }

    @Override
    protected Optional<ImportedExternalFilter> load(MatchResult matcher) {
        String reference = matcher.group(1);
        try {
            Filter loaded = SearchFilterFiles.getFilterByName(reference);
            return Optional.of(new ImportedExternalFilter(reference, loaded));
        }
        catch (Exception e) {
            log.error("Exception loading referenced filter '{}': {}.", (Object)reference, (Object)e.getMessage());
            return Optional.empty();
        }
        catch (StackOverflowError e) {
            log.error("Encountered an infinite loop when loading cascading filters, e.g. see '{}'.", (Object)reference);
            return Optional.empty();
        }
    }
}

