/*
 * Decompiled with CFR 0.152.
 */
package de.retest.recheck.review.ignore.io;

import de.retest.recheck.review.ignore.io.Loader;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.tuple.Pair;

public final class InheritanceLoader<T>
implements Loader<T> {
    private final List<Pair<Class<? extends T>, Loader<? extends T>>> registeredLoaders;

    @Override
    public Optional<T> load(String line) {
        return this.registeredLoaders.stream().map(Pair::getRight).map(loader -> loader.load(line)).filter(Optional::isPresent).findFirst().map(Optional::get);
    }

    @Override
    public String save(T object) {
        Class<?> clazz = object.getClass();
        return this.registeredLoaders.stream().filter(pair -> ((Class)pair.getLeft()).isAssignableFrom(clazz)).findFirst().map(pair -> (Loader)pair.getRight()).map(loader -> loader.save(object)).orElseThrow(() -> this.noLoaderFor(object));
    }

    private UnsupportedOperationException noLoaderFor(T object) {
        return new UnsupportedOperationException(String.format("Did not find a loader for %s.", object));
    }

    public InheritanceLoader(List<Pair<Class<? extends T>, Loader<? extends T>>> registeredLoaders) {
        this.registeredLoaders = registeredLoaders;
    }
}

