/*
 * Decompiled with CFR 0.152.
 */
package de.retest.recheck.review.ignore.matcher;

import de.retest.recheck.review.ignore.io.RegexLoader;
import de.retest.recheck.review.ignore.matcher.Matcher;
import de.retest.recheck.ui.descriptors.Element;
import java.util.Optional;
import java.util.regex.MatchResult;
import java.util.regex.Pattern;

public class ElementByAttributeMatcher
implements Matcher<Element> {
    private final String key;
    private final String value;

    public ElementByAttributeMatcher(String key, String value) {
        this.key = key;
        this.value = value;
    }

    @Override
    public boolean test(Element element) {
        Object elementAttribute = element.getIdentifyingAttributes().get(this.key);
        if (elementAttribute != null) {
            return this.value.equals(elementAttribute);
        }
        elementAttribute = element.getAttributes().get(this.key);
        return this.value.equals(elementAttribute);
    }

    public String toString() {
        return this.key + "=" + this.value;
    }

    public static final class ElementByAttributeMatcherLoader
    extends RegexLoader<ElementByAttributeMatcher> {
        private static final Pattern REGEX = Pattern.compile("(.+)=(.+)");

        public ElementByAttributeMatcherLoader() {
            super(REGEX);
        }

        @Override
        protected Optional<ElementByAttributeMatcher> load(MatchResult matcher) {
            String key = matcher.group(1);
            String value = matcher.group(2);
            return Optional.of(new ElementByAttributeMatcher(key, value));
        }
    }
}

