/*
 * Decompiled with CFR 0.152.
 */
package de.retest.recheck.review.ignore.matcher;

import de.retest.recheck.review.ignore.io.RegexLoader;
import de.retest.recheck.review.ignore.matcher.Matcher;
import de.retest.recheck.ui.descriptors.Element;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.regex.MatchResult;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class ElementClassMatcher
implements Matcher<Element> {
    public static final String CLASS_KEY = "class";
    private final List<String> classes;

    public ElementClassMatcher(Element element) {
        this(ElementClassMatcher.toClassValuesList(ElementClassMatcher.toClassValueString(element)));
    }

    private ElementClassMatcher(List<String> classValues) {
        this.classes = classValues;
    }

    @Override
    public boolean test(Element element) {
        List<String> elementClasses = ElementClassMatcher.toClassValuesList(ElementClassMatcher.toClassValueString(element));
        if (this.classes.isEmpty()) {
            return false;
        }
        return elementClasses.containsAll(this.classes);
    }

    public String toString() {
        String classValueString = this.classes.stream().collect(Collectors.joining(" "));
        return String.format("class=%s", classValueString);
    }

    private static String toClassValueString(Element element) {
        return (String)element.getIdentifyingAttributes().get(CLASS_KEY);
    }

    private static List<String> toClassValuesList(String classValue) {
        if (classValue == null) {
            return Collections.emptyList();
        }
        return Arrays.asList(classValue.split(" "));
    }

    public static final class ElementClassMatcherLoader
    extends RegexLoader<ElementClassMatcher> {
        private static final String CLASS = "class=";
        private static final String FORMAT = "class=%s";
        private static final Pattern REGEX = Pattern.compile("class=(.+)");

        public ElementClassMatcherLoader() {
            super(REGEX);
        }

        @Override
        protected Optional<ElementClassMatcher> load(MatchResult matcher) {
            String classValue = matcher.group(1);
            return Optional.of(new ElementClassMatcher(ElementClassMatcher.toClassValuesList(classValue)));
        }
    }
}

