/*
 * Decompiled with CFR 0.152.
 */
package de.retest.recheck.review.ignore.matcher;

import de.retest.recheck.review.ignore.io.RegexLoader;
import de.retest.recheck.review.ignore.matcher.Matcher;
import de.retest.recheck.ui.descriptors.Element;
import java.util.Optional;
import java.util.regex.MatchResult;
import java.util.regex.Pattern;

public class ElementIdMatcher
implements Matcher<Element> {
    private final String id;

    public ElementIdMatcher(Element element) {
        this(element.getIdentifyingAttributes().get("id") != null ? element.getIdentifyingAttributes().get("id").toString() : "");
    }

    public ElementIdMatcher(String id) {
        this.id = id;
    }

    @Override
    public boolean test(Element element) {
        String elementId = (String)element.getIdentifyingAttributes().get("id");
        return elementId != null && elementId.matches(this.id);
    }

    public String toString() {
        return String.format("id=%s", this.id);
    }

    public static final class ElementIdMatcherLoader
    extends RegexLoader<ElementIdMatcher> {
        private static final String ID = "id=";
        private static final String FORMAT = "id=%s";
        private static final Pattern REGEX = Pattern.compile("id=(.+)");

        public ElementIdMatcherLoader() {
            super(REGEX);
        }

        @Override
        protected Optional<ElementIdMatcher> load(MatchResult matcher) {
            String id = matcher.group(1);
            return Optional.of(new ElementIdMatcher(id));
        }
    }
}

