/*
 * Decompiled with CFR 0.152.
 */
package de.retest.recheck.review.ignore.matcher;

import de.retest.recheck.review.ignore.io.RegexLoader;
import de.retest.recheck.review.ignore.matcher.Matcher;
import de.retest.recheck.ui.descriptors.Element;
import java.util.Optional;
import java.util.regex.MatchResult;
import java.util.regex.Pattern;

public class ElementRetestIdMatcher
implements Matcher<Element> {
    private final String retestid;

    public ElementRetestIdMatcher(Element element) {
        this(element.getRetestId());
    }

    private ElementRetestIdMatcher(String id) {
        this.retestid = id;
    }

    @Override
    public boolean test(Element element) {
        return element.getRetestId().matches(this.retestid);
    }

    public String toString() {
        return String.format("retestid=%s", this.retestid);
    }

    public static final class ElementRetestIdMatcherLoader
    extends RegexLoader<ElementRetestIdMatcher> {
        private static final String RETEST_ID = "retestid=";
        private static final String FORMAT = "retestid=%s";
        private static final Pattern REGEX = Pattern.compile("retestid=(.+)");

        public ElementRetestIdMatcherLoader() {
            super(REGEX);
        }

        @Override
        protected Optional<ElementRetestIdMatcher> load(MatchResult matcher) {
            String id = matcher.group(1);
            return Optional.of(new ElementRetestIdMatcher(id));
        }
    }
}

