/*
 * Decompiled with CFR 0.152.
 */
package de.retest.recheck.review.ignore.matcher;

import de.retest.recheck.review.ignore.io.RegexLoader;
import de.retest.recheck.review.ignore.matcher.Matcher;
import de.retest.recheck.ui.descriptors.Element;
import java.util.Optional;
import java.util.regex.MatchResult;
import java.util.regex.Pattern;

public class ElementTypeMatcher
implements Matcher<Element> {
    private final String type;

    public ElementTypeMatcher(Element element) {
        this(element.getIdentifyingAttributes().getType());
    }

    private ElementTypeMatcher(String type) {
        this.type = type;
        assert (type != null);
    }

    @Override
    public boolean test(Element element) {
        return element.getIdentifyingAttributes().getType().matches(this.type);
    }

    public String toString() {
        return String.format("type=%s", this.type);
    }

    public static final class ElementTypeMatcherLoader
    extends RegexLoader<ElementTypeMatcher> {
        private static final String TYPE = "type=";
        private static final String FORMAT = "type=%s";
        private static final Pattern REGEX = Pattern.compile("type=(.+)");

        public ElementTypeMatcherLoader() {
            super(REGEX);
        }

        @Override
        protected Optional<ElementTypeMatcher> load(MatchResult matcher) {
            String type = matcher.group(1);
            return Optional.of(new ElementTypeMatcher(type));
        }
    }
}

