/*
 * Decompiled with CFR 0.152.
 */
package de.retest.recheck.review.ignore.matcher;

import de.retest.recheck.review.ignore.io.RegexLoader;
import de.retest.recheck.review.ignore.matcher.Matcher;
import de.retest.recheck.ui.Path;
import de.retest.recheck.ui.descriptors.Element;
import java.util.Optional;
import java.util.regex.MatchResult;
import java.util.regex.Pattern;

public class ElementXPathMatcher
implements Matcher<Element> {
    private final String givenXPath;
    private final String normalizedXPath;

    public ElementXPathMatcher(Element element) {
        this.givenXPath = this.normalizedXPath = element.getIdentifyingAttributes().getPath();
    }

    private ElementXPathMatcher(String xpath) {
        this.givenXPath = xpath;
        this.normalizedXPath = Path.fromString(xpath).toString();
    }

    @Override
    public boolean test(Element element) {
        return element.getIdentifyingAttributes().getPath().equals(this.normalizedXPath);
    }

    public String toString() {
        return String.format("xpath=%s", this.givenXPath);
    }

    public static final class ElementXpathMatcherLoader
    extends RegexLoader<ElementXPathMatcher> {
        private static final String XPATH = "xpath=";
        private static final String FORMAT = "xpath=%s";
        private static final Pattern REGEX = Pattern.compile("xpath=(.+)");

        public ElementXpathMatcherLoader() {
            super(REGEX);
        }

        @Override
        protected Optional<ElementXPathMatcher> load(MatchResult matcher) {
            String xpath = matcher.group(1);
            return Optional.of(new ElementXPathMatcher(xpath));
        }
    }
}

