/*
 * Decompiled with CFR 0.152.
 */
package de.retest.recheck.review.workers;

import de.retest.recheck.ignore.CacheFilter;
import de.retest.recheck.ignore.JSFilterImpl;
import de.retest.recheck.ignore.PersistentFilter;
import de.retest.recheck.ignore.RecheckIgnoreLocator;
import de.retest.recheck.review.GlobalIgnoreApplier;
import de.retest.recheck.review.counter.Counter;
import de.retest.recheck.review.ignore.io.Loaders;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoadFilterWorker {
    private static final Logger log = LoggerFactory.getLogger(LoadFilterWorker.class);
    private final Counter counter;
    private final Path ignoreFilesBasePath;
    private final RecheckIgnoreLocator locator = new RecheckIgnoreLocator();
    private final RecheckIgnoreLocator jsIgnoreLocator = new RecheckIgnoreLocator("recheck.ignore.js");

    public LoadFilterWorker(Counter counter) {
        this(counter, null);
    }

    public LoadFilterWorker(Counter counter, Path ignoreFilesBasePath) {
        this.counter = counter;
        this.ignoreFilesBasePath = ignoreFilesBasePath;
    }

    public GlobalIgnoreApplier load() throws IOException {
        Stream<PersistentFilter> allIgnoreFileLines = this.readIgnoreFileFilters();
        GlobalIgnoreApplier.PersistableGlobalIgnoreApplier ignoreApplier = new GlobalIgnoreApplier.PersistableGlobalIgnoreApplier(allIgnoreFileLines.collect(Collectors.toList()));
        GlobalIgnoreApplier result = GlobalIgnoreApplier.create(this.counter, ignoreApplier);
        this.readIgnoreRuleFileFilters(result);
        return result;
    }

    private Stream<PersistentFilter> readIgnoreFileFilters() throws IOException {
        Optional<Path> projectIgnoreFile = this.locator.getProjectIgnoreFile();
        Path userIgnoreFile = this.locator.getUserIgnoreFile();
        return Stream.concat(Stream.concat(this.getProjectIgnoreFileFilters(projectIgnoreFile), this.getUserIgnoreFileFilters(userIgnoreFile)), this.getSuiteIgnoreFileFilters());
    }

    protected Stream<PersistentFilter> getSuiteIgnoreFileFilters() throws IOException {
        if (this.ignoreFilesBasePath != null) {
            Path suiteIgnoreFile = this.locator.getSuiteIgnoreFile(this.ignoreFilesBasePath);
            return this.getIgnoreFileFilters(suiteIgnoreFile);
        }
        return Stream.empty();
    }

    protected Stream<PersistentFilter> getUserIgnoreFileFilters(Path userIgnoreFile) throws IOException {
        return this.getIgnoreFileFilters(userIgnoreFile);
    }

    protected Stream<PersistentFilter> getProjectIgnoreFileFilters(Optional<Path> projectIgnoreFile) throws IOException {
        return this.getIgnoreFileFilters(projectIgnoreFile);
    }

    private void readIgnoreRuleFileFilters(GlobalIgnoreApplier result) {
        Optional<Path> projectIgnoreRuleFile = this.jsIgnoreLocator.getProjectIgnoreFile();
        Path userIgnoreRuleFile = this.jsIgnoreLocator.getUserIgnoreFile();
        this.addIgnoreRuleFiles(projectIgnoreRuleFile, result);
        this.addIgnoreRuleFiles(userIgnoreRuleFile, result);
        if (this.ignoreFilesBasePath != null) {
            Path suiteIgnoreRuleFile = this.jsIgnoreLocator.getSuiteIgnoreFile(this.ignoreFilesBasePath);
            this.addIgnoreRuleFiles(suiteIgnoreRuleFile, result);
        }
    }

    private Stream<PersistentFilter> getIgnoreFileFilters(Optional<Path> ignoreFile) throws IOException {
        if (ignoreFile.isPresent()) {
            return this.getIgnoreFileFilters(ignoreFile.get());
        }
        log.info("Ignoring missing ignore file.");
        return Stream.empty();
    }

    private Stream<PersistentFilter> getIgnoreFileFilters(Path ignoreFile) throws IOException {
        if (ignoreFile.toFile().exists()) {
            log.info("Reading ignore file from '{}'.", (Object)ignoreFile);
            return PersistentFilter.wrap(ignoreFile, Loaders.filter().load(Files.lines(ignoreFile)));
        }
        log.info("No ignore file found at '{}'.", (Object)ignoreFile);
        return Stream.empty();
    }

    private void addIgnoreRuleFiles(Optional<Path> ignoreRuleFile, GlobalIgnoreApplier result) {
        if (ignoreRuleFile.isPresent()) {
            this.addIgnoreRuleFiles(ignoreRuleFile.get(), result);
        }
    }

    private void addIgnoreRuleFiles(Path ignoreRuleFile, GlobalIgnoreApplier result) {
        if (ignoreRuleFile.toFile().exists()) {
            log.info("Reading ignore file from '{}'.", (Object)ignoreRuleFile.toFile());
            result.addWithoutCounting(new PersistentFilter(ignoreRuleFile, new CacheFilter(new JSFilterImpl(ignoreRuleFile))));
        } else {
            log.info("No ignore file found at '{}'.", (Object)ignoreRuleFile.toFile());
        }
    }

    public Counter getCounter() {
        return this.counter;
    }
}

