/*
 * Decompiled with CFR 0.152.
 */
package de.retest.recheck.review.workers;

import de.retest.recheck.ignore.CacheFilter;
import de.retest.recheck.ignore.JSFilterImpl;
import de.retest.recheck.ignore.PersistentFilter;
import de.retest.recheck.review.GlobalIgnoreApplier;
import de.retest.recheck.review.ignore.io.Loaders;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SaveFilterWorker {
    private static final Logger log = LoggerFactory.getLogger(SaveFilterWorker.class);
    private final GlobalIgnoreApplier applier;

    public SaveFilterWorker(GlobalIgnoreApplier applier) {
        this.applier = applier;
    }

    public void save() throws IOException {
        GlobalIgnoreApplier.PersistableGlobalIgnoreApplier persist = this.applier.persist();
        Stream<PersistentFilter> filters = persist.getIgnores().stream().map(this::extractCachedFilter).filter(f -> !(f.getFilter() instanceof JSFilterImpl));
        Map<Path, List<PersistentFilter>> mapped = filters.collect(Collectors.groupingBy(PersistentFilter::getPath));
        for (Map.Entry<Path, List<PersistentFilter>> line : mapped.entrySet()) {
            List save = line.getValue().stream().map(f -> Loaders.filter().save(f.getFilter())).collect(Collectors.toList());
            Path target = line.getKey();
            log.info("Writing filters to file '{}'.", (Object)target);
            Files.createDirectories(target.getParent(), new FileAttribute[0]);
            Files.write(target, save, new OpenOption[0]);
        }
    }

    private PersistentFilter extractCachedFilter(PersistentFilter filter) {
        if (filter.getFilter() instanceof CacheFilter) {
            return new PersistentFilter(filter.getPath(), ((CacheFilter)filter.getFilter()).getBase());
        }
        return filter;
    }
}

