/*
 * Decompiled with CFR 0.152.
 */
package de.retest.recheck.suite;

import com.google.common.base.Objects;
import de.retest.recheck.persistence.Persistable;
import de.retest.recheck.suite.ExecutionSuitesDoNotMatchException;
import de.retest.recheck.ui.actions.ActionStateSequence;
import de.retest.recheck.ui.descriptors.GroundState;
import de.retest.recheck.ui.review.SuiteChangeSet;
import de.retest.recheck.ui.review.TestChangeSet;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class ExecutableSuite
extends Persistable {
    private static final long serialVersionUID = 4L;
    private static final int PERSISTENCE_VERSION = 23;
    @XmlAttribute
    private final String uuid;
    @XmlElement
    private final List<ActionStateSequence> tests = new ArrayList<ActionStateSequence>();
    @XmlElement
    private final GroundState groundState;
    @XmlElement
    private final long sumDuration;
    private String name;

    private ExecutableSuite() {
        super(23);
        this.groundState = null;
        this.sumDuration = 0L;
        this.uuid = null;
    }

    public ExecutableSuite(GroundState groundState, long sumDuration, List<ActionStateSequence> tests) {
        super(23);
        this.groundState = groundState;
        this.sumDuration = sumDuration;
        this.uuid = UUID.randomUUID().toString();
        this.addTests(tests);
    }

    public List<ActionStateSequence> getTests() {
        return this.tests;
    }

    public void addTests(List<ActionStateSequence> actionStateSequences) {
        this.tests.addAll(actionStateSequences);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public GroundState getGroundState() {
        return this.groundState;
    }

    public long getSumDuration() {
        return this.sumDuration;
    }

    public ExecutableSuite applyChanges(SuiteChangeSet suiteChangeSet) throws ExecutionSuitesDoNotMatchException {
        if (!Objects.equal((Object)suiteChangeSet.getUuid(), (Object)this.uuid)) {
            throw new ExecutionSuitesDoNotMatchException(this.uuid, suiteChangeSet.getUuid());
        }
        ArrayList<ActionStateSequence> newTests = new ArrayList<ActionStateSequence>();
        for (int i = 0; i < this.tests.size(); ++i) {
            newTests.add(ExecutableSuite.manipulate(this.tests.get(i), suiteChangeSet.getTestChangeSet(i)));
        }
        return new ExecutableSuite(this.groundState, this.sumDuration, newTests);
    }

    private static ActionStateSequence manipulate(ActionStateSequence test, TestChangeSet testChangeSet) {
        if (testChangeSet != null) {
            return test.applyChanges(testChangeSet);
        }
        return test;
    }

    public String getUuid() {
        return this.uuid;
    }
}

