/*
 * Decompiled with CFR 0.152.
 */
package de.retest.recheck.suite.flow;

import de.retest.recheck.persistence.GoldenMasterProvider;
import de.retest.recheck.persistence.GoldenMasterProviderImpl;
import de.retest.recheck.persistence.NoGoldenMasterFoundException;
import de.retest.recheck.persistence.Persistence;
import de.retest.recheck.ui.descriptors.SutState;
import de.retest.recheck.ui.review.ActionChangeSet;
import de.retest.recheck.ui.review.SuiteChangeSet;
import de.retest.recheck.ui.review.TestChangeSet;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApplyChangesToStatesFlow {
    private static final Logger logger = LoggerFactory.getLogger(ApplyChangesToStatesFlow.class);
    private final GoldenMasterProvider goldenMasterProvider;
    private final List<String> missingGoldenMastersFilenames = new ArrayList<String>();

    public static List<String> apply(Persistence<SutState> persistence, SuiteChangeSet acceptedChanges) throws NoGoldenMasterFoundException {
        return new ApplyChangesToStatesFlow(persistence).apply(acceptedChanges);
    }

    private ApplyChangesToStatesFlow(Persistence<SutState> persistence) {
        this.goldenMasterProvider = new GoldenMasterProviderImpl(persistence);
    }

    private List<String> apply(SuiteChangeSet acceptedChanges) throws NoGoldenMasterFoundException {
        ArrayList<String> updatedFiles = new ArrayList<String>();
        for (TestChangeSet testChangeSet : acceptedChanges.getTestChangeSets()) {
            updatedFiles.addAll(this.apply(testChangeSet));
        }
        if (!this.missingGoldenMastersFilenames.isEmpty()) {
            throw new NoGoldenMasterFoundException((String[])this.missingGoldenMastersFilenames.stream().toArray(String[]::new));
        }
        return updatedFiles;
    }

    private List<String> apply(TestChangeSet testChangeSet) {
        if (testChangeSet.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> updatedFiles = new ArrayList<String>();
        for (ActionChangeSet changeSet : testChangeSet.getActionChangeSets()) {
            updatedFiles.addAll(this.apply(changeSet));
        }
        if (testChangeSet.containsInitialStateChangeSet()) {
            ActionChangeSet changeSet = testChangeSet.getInitialStateChangeSet();
            updatedFiles.addAll(this.apply(changeSet));
        }
        return updatedFiles;
    }

    private List<String> apply(ActionChangeSet actionChangeSet) {
        if (actionChangeSet.isEmpty()) {
            return Collections.emptyList();
        }
        try {
            File file = this.goldenMasterProvider.getGoldenMaster(actionChangeSet.getGoldenMasterPath());
            SutState oldState = this.goldenMasterProvider.loadGoldenMaster(file);
            SutState newState = oldState.applyChanges(actionChangeSet);
            if (newState.equals(oldState)) {
                logger.debug("SutState {} did not change after applying changes, so not persisting it...", (Object)oldState);
                return Collections.emptyList();
            }
            this.goldenMasterProvider.saveGoldenMaster(file, newState);
            return Collections.singletonList(file.getName());
        }
        catch (NoGoldenMasterFoundException e) {
            this.missingGoldenMastersFilenames.addAll(e.getFilenames());
            return Collections.emptyList();
        }
    }
}

