/*
 * Decompiled with CFR 0.152.
 */
package de.retest.recheck.suite.flow;

import de.retest.recheck.report.ActionReplayResult;
import de.retest.recheck.report.SuiteReplayResult;
import de.retest.recheck.report.TestReplayResult;
import de.retest.recheck.report.TestReport;
import de.retest.recheck.ui.diff.ElementDifference;
import de.retest.recheck.ui.diff.IdentifyingAttributesDifference;
import de.retest.recheck.ui.diff.InsertedDeletedElementDifference;
import de.retest.recheck.ui.review.ActionChangeSet;
import de.retest.recheck.ui.review.ReviewResult;
import de.retest.recheck.ui.review.ScreenshotChanges;
import de.retest.recheck.ui.review.SuiteChangeSet;
import de.retest.recheck.ui.review.TestChangeSet;

public class CreateChangesetForAllDifferencesFlow {
    private final TestReport testReport;
    private final ReviewResult reviewResult;

    private CreateChangesetForAllDifferencesFlow(TestReport testReport) {
        this.testReport = testReport;
        this.reviewResult = new ReviewResult();
    }

    public static ReviewResult create(TestReport testReport) {
        CreateChangesetForAllDifferencesFlow flow = new CreateChangesetForAllDifferencesFlow(testReport);
        flow.create();
        return flow.reviewResult;
    }

    private void create() {
        for (SuiteReplayResult suite : this.testReport.getSuiteReplayResults()) {
            SuiteChangeSet suiteChangeSet = this.reviewResult.createSuiteChangeSet(suite.getName(), suite.getSuiteUuid());
            for (TestReplayResult test : suite.getTestReplayResults()) {
                TestChangeSet testChangeSet = suiteChangeSet.createTestChangeSet();
                boolean first = true;
                for (ActionReplayResult actionReplayResult : test.getActionReplayResults()) {
                    String description = actionReplayResult.getDescription();
                    String goldenMasterPath = actionReplayResult.getGoldenMasterPath();
                    ScreenshotChanges actualScreenshot = ScreenshotChanges.actual(actionReplayResult);
                    if (first) {
                        if (testChangeSet.getInitialStateChangeSet().isEmpty()) {
                            this.addAllElementDifferences(actionReplayResult, testChangeSet.createInitialActionChangeSet(description, goldenMasterPath, actualScreenshot));
                        } else {
                            this.addAllElementDifferences(actionReplayResult, testChangeSet.getInitialStateChangeSet());
                        }
                        first = false;
                        continue;
                    }
                    ActionChangeSet actionChangeSet = testChangeSet.createActionChangeSet(description, goldenMasterPath, actualScreenshot);
                    if (actionReplayResult.getStateDifference() == null) continue;
                    this.addAllElementDifferences(actionReplayResult, actionChangeSet);
                }
            }
        }
    }

    private void addAllElementDifferences(ActionReplayResult actionReplayResult, ActionChangeSet actionChangeSet) {
        for (ElementDifference elementDifference : actionReplayResult.getAllElementDifferences()) {
            if (elementDifference.isInsertion()) {
                actionChangeSet.addInsertChange(((InsertedDeletedElementDifference)elementDifference.getIdentifyingAttributesDifference()).getActual());
                continue;
            }
            if (elementDifference.isDeletion()) {
                actionChangeSet.addDeletedChange(((InsertedDeletedElementDifference)elementDifference.getIdentifyingAttributesDifference()).getExpected().getIdentifyingAttributes());
                continue;
            }
            if (elementDifference.hasIdentAttributesDifferences()) {
                actionChangeSet.getIdentAttributeChanges().addAll(elementDifference.getIdentifyingAttributes(), ((IdentifyingAttributesDifference)elementDifference.getIdentifyingAttributesDifference()).getAttributeDifferences());
            }
            if (!elementDifference.hasAttributesDifferences()) continue;
            actionChangeSet.getAttributesChanges().addAll(elementDifference.getIdentifyingAttributes(), elementDifference.getAttributesDifference().getDifferences());
        }
    }
}

