/*
 * Decompiled with CFR 0.152.
 */
package de.retest.recheck.ui;

import java.io.Serializable;
import java.util.Objects;

public class PathElement
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String elementName;
    private final int suffix;

    public PathElement(String elementName, int suffix) {
        if (elementName == null) {
            throw new NullPointerException("Element name must not be null.");
        }
        this.elementName = elementName.trim();
        if (this.elementName.isEmpty()) {
            throw new IllegalArgumentException("Element name must not be empty.");
        }
        this.suffix = suffix;
    }

    public PathElement(String elementName) {
        this(elementName, 1);
    }

    public String getElementName() {
        return this.elementName;
    }

    public int getSuffix() {
        return this.suffix;
    }

    public String toString() {
        return this.elementName + "[" + this.suffix + "]";
    }

    public int hashCode() {
        return Objects.hash(this.elementName, this.suffix);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        PathElement other = (PathElement)obj;
        return this.elementName.equals(other.elementName) && this.suffix == other.suffix;
    }

    public static PathElement fromString(String path) {
        if (!path.contains("[")) {
            return new PathElement(path);
        }
        return new PathElement(path.substring(0, path.indexOf(91)), Integer.parseInt(path.substring(path.indexOf(91) + 1, path.length() - 1)));
    }
}

