/*
 * Decompiled with CFR 0.152.
 */
package de.retest.recheck.ui.actions;

import de.retest.recheck.ui.Environment;
import de.retest.recheck.ui.actions.Action;
import de.retest.recheck.ui.actions.ActionExecutionResult;
import de.retest.recheck.ui.actions.ExceptionWrapper;
import de.retest.recheck.ui.actions.TargetNotFoundException;
import de.retest.recheck.ui.components.Component;
import de.retest.recheck.ui.descriptors.Element;
import de.retest.recheck.ui.descriptors.IdentifyingAttributes;
import de.retest.recheck.ui.image.Screenshot;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import java.util.UUID;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@XmlAccessorType(value=XmlAccessType.FIELD)
public abstract class AbstractAction
implements Action {
    private static final long serialVersionUID = 2L;
    public static final String ACTION_PREFIX = "action";
    private static final Logger logger = LoggerFactory.getLogger(AbstractAction.class);
    @XmlElement
    protected final Element element;
    @XmlAttribute
    private final String uuid;
    @XmlElement
    private Screenshot[] windowsScreenshots;

    public AbstractAction(Element element, Screenshot[] windowScreenshots) {
        if (element == null) {
            throw new NullPointerException("Target must not be null!");
        }
        this.element = element;
        this.windowsScreenshots = windowScreenshots;
        this.uuid = UUID.randomUUID().toString();
    }

    protected AbstractAction() {
        this.element = null;
        this.uuid = null;
    }

    @Override
    public int compareTo(Action other) {
        return AbstractAction.getActionIdentifyingAttributesOf(this).compareTo(AbstractAction.getActionIdentifyingAttributesOf(other));
    }

    @Override
    public String getUuid() {
        return this.uuid;
    }

    public abstract String createDescription();

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof AbstractAction) {
            AbstractAction other = (AbstractAction)object;
            if (AbstractAction.getActionIdentifyingAttributesOf(this).equals(AbstractAction.getActionIdentifyingAttributesOf(other))) {
                return true;
            }
        }
        return false;
    }

    @Override
    public <T> ActionExecutionResult execute(Environment<T> environment) {
        try {
            ImmutablePair<TargetNotFoundException, Component<T>> result = environment.findTargetComponent(this);
            if (result.left != null) {
                return new ActionExecutionResult((TargetNotFoundException)result.left);
            }
            if (this.getTargetElement().getScreenshot() == null) {
                this.getTargetElement().setScreenshot(((Component)result.right).createScreenshot());
            }
            this.execute((Component)result.right);
            return new ActionExecutionResult(null, -1L);
        }
        catch (TargetNotFoundException exc) {
            return new ActionExecutionResult(null, exc, -1L);
        }
        catch (Throwable t) {
            return new ActionExecutionResult(new ExceptionWrapper(t), -1L);
        }
    }

    protected void throwTargetNotFoundForExecution(Component<?> component) throws TargetNotFoundException {
        throw new TargetNotFoundException(this, component.getElement(), this.getWindowsScreenshots(), "Tried to execute a action with wrong component peer");
    }

    private static Pair<Class<? extends Action>, IdentifyingAttributes> getActionIdentifyingAttributesOf(Action action) {
        return Pair.of(action.getClass(), (Object)action.getTargetElement().getIdentifyingAttributes());
    }

    @Override
    public Element getTargetElement() {
        return this.element;
    }

    @Override
    public int hashCode() {
        return AbstractAction.getActionIdentifyingAttributesOf(this).hashCode();
    }

    @Override
    public Action randomize() {
        logger.warn("Randomize not implemented for {}.", this.getClass());
        return this;
    }

    public String toString() {
        return this.createDescription();
    }

    @Override
    public Screenshot[] getWindowsScreenshots() {
        return this.windowsScreenshots;
    }

    @Override
    public void setWindowsScreenshots(Screenshot[] windowsScreenshots) {
        this.windowsScreenshots = windowsScreenshots;
    }
}

