/*
 * Decompiled with CFR 0.152.
 */
package de.retest.recheck.ui.actions;

import de.retest.recheck.ui.actions.ExceptionWrapper;
import de.retest.recheck.ui.actions.TargetNotFoundException;
import java.io.Serializable;

public class ActionExecutionResult
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final ExceptionWrapper error;
    private final TargetNotFoundException targetNotFound;
    private final long duration;

    public ActionExecutionResult(ExceptionWrapper error, TargetNotFoundException targetNotFound, long duration) {
        this.error = error;
        this.targetNotFound = targetNotFound;
        this.duration = duration;
    }

    public ActionExecutionResult(ExceptionWrapper error, long duration) {
        this(error, null, duration);
    }

    public ActionExecutionResult(TargetNotFoundException targetNotFound) {
        this(null, targetNotFound, -1L);
    }

    public ExceptionWrapper getError() {
        return this.error;
    }

    public TargetNotFoundException getTargetNotFound() {
        return this.targetNotFound;
    }

    public long getDuration() {
        return this.duration;
    }

    public String toString() {
        StringBuilder result = new StringBuilder("execution took ").append(this.duration).append("ms");
        if (this.getError() != null) {
            result.append(" and resulted in ").append(this.error.toString());
        }
        if (this.getTargetNotFound() != null) {
            result.append(" and did not find target ").append(this.targetNotFound.toString());
        }
        return result.toString();
    }
}

