/*
 * Decompiled with CFR 0.152.
 */
package de.retest.recheck.ui.actions;

import de.retest.recheck.ui.actions.Action;
import de.retest.recheck.ui.descriptors.SutState;
import de.retest.recheck.ui.review.ActionChangeSet;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAnyElement;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.io.Serializable;
import java.util.Objects;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class ActionState
implements Serializable {
    private static final long serialVersionUID = 2L;
    @XmlElement
    private final SutState state;
    @XmlElement
    private final long duration;
    @XmlAnyElement(lax=true)
    private final Action action;

    private ActionState() {
        this.action = null;
        this.state = null;
        this.duration = 0L;
    }

    public ActionState(Action action, SutState resultingState, long duration) {
        if (action == null || resultingState == null) {
            throw new NullPointerException("action and resultingState cannot be null.");
        }
        this.action = action;
        this.state = resultingState;
        this.duration = duration;
    }

    public SutState getState() {
        return this.state;
    }

    public Action getAction() {
        return this.action;
    }

    public long getDuration() {
        return this.duration;
    }

    public int hashCode() {
        return Objects.hash(this.action, this.duration, this.state);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ActionState other = (ActionState)obj;
        return Objects.equals(this.action, other.action) && this.duration == other.duration && Objects.equals(this.state, other.state);
    }

    public String toString() {
        return this.action.toString();
    }

    public ActionState applyChanges(ActionChangeSet actionChangeSet) {
        Action action = this.getAction().applyChanges(actionChangeSet);
        SutState resultingState = this.getState().applyChanges(actionChangeSet);
        return new ActionState(action, resultingState, this.duration);
    }
}

