/*
 * Decompiled with CFR 0.152.
 */
package de.retest.recheck.ui.actions;

import de.retest.recheck.ui.actions.Action;
import de.retest.recheck.ui.actions.ActionParameter;
import de.retest.recheck.ui.actions.ParameterizedAction;
import de.retest.recheck.ui.actions.ValueProvider;
import de.retest.recheck.ui.descriptors.Attribute;
import de.retest.recheck.ui.descriptors.Element;
import de.retest.recheck.ui.descriptors.IdentifyingAttributes;
import de.retest.recheck.ui.descriptors.ParameterType;
import de.retest.recheck.ui.descriptors.ParameterizedAttribute;
import de.retest.recheck.ui.descriptors.ParseStringAttributeDifference;
import de.retest.recheck.ui.descriptors.VariableNameAttributeDifference;
import de.retest.recheck.ui.diff.AttributeDifference;
import de.retest.recheck.ui.review.ActionChangeSet;
import de.retest.recheck.ui.review.AttributeChanges;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Actions {
    private static final Logger logger = LoggerFactory.getLogger(Actions.class);

    private Actions() {
    }

    public static ActionChangeSet createParameterValueChangeSet(Action action, ParameterizedAttribute attribute, String value) {
        VariableNameAttributeDifference difference = new VariableNameAttributeDifference(attribute, value);
        return Actions.singleTonChangeSet(action, difference);
    }

    private static ActionChangeSet singleTonChangeSet(Action action, AttributeDifference difference) {
        Element element = action.getTargetElement();
        IdentifyingAttributes identifyingAttributes = element.getIdentifyingAttributes();
        ActionChangeSet changeSet = new ActionChangeSet();
        changeSet.getIdentAttributeChanges().add(identifyingAttributes, difference);
        return changeSet;
    }

    public static Action convertActionIfPossible(Action action, ValueProvider provider) {
        if (Actions.isParameterizedAction(action, provider)) {
            return Actions.convertAction((ParameterizedAction)action, provider);
        }
        return action;
    }

    private static Action convertAction(ParameterizedAction action, ValueProvider provider) {
        Set<ActionParameter> parameters = action.getActionParameter();
        HashSet<ActionParameter> newParameters = new HashSet<ActionParameter>(parameters.size());
        for (ActionParameter parameter : parameters) {
            newParameters.add(Actions.convertActionParameterIfPossible(provider, parameter));
        }
        ParameterizedAction changes = action.applyChanges(newParameters);
        IdentifyingAttributes attributes = action.getTargetElement().getIdentifyingAttributes();
        ActionChangeSet changeSet = new ActionChangeSet();
        AttributeChanges attributeChanges = changeSet.getIdentAttributeChanges();
        for (Attribute attribute : attributes.getAttributes()) {
            AttributeDifference difference = Actions.createAttributeDifferenceIfPossible(attribute, provider);
            if (difference == null) continue;
            attributeChanges.add(attributes, difference);
        }
        return changes.applyChanges(changeSet);
    }

    private static ActionParameter convertActionParameterIfPossible(ValueProvider provider, ActionParameter parameter) {
        String variableName = parameter.getVariableName();
        if (Actions.isVariableNameInvalid(variableName)) {
            logger.debug("ActionParameter {} was not validated with name {}.", (Object)parameter, (Object)variableName);
            return parameter;
        }
        String variableValue = provider.get(variableName);
        if (StringUtils.isEmpty((CharSequence)variableValue) || Actions.isVariableValueInvalid(parameter, variableValue)) {
            logger.debug("ActionParameter {} was not validated with value {}.", (Object)parameter, (Object)variableValue);
            return parameter;
        }
        return parameter.setValue(variableValue);
    }

    private static AttributeDifference createAttributeDifferenceIfPossible(Attribute attribute, ValueProvider provider) {
        if (attribute instanceof ParameterizedAttribute) {
            ParameterizedAttribute param = (ParameterizedAttribute)attribute;
            String variableName = param.getVariableName();
            if (Actions.isVariableNameInvalid(variableName)) {
                logger.debug("Attribute {} was not validated with name {}.", (Object)attribute, (Object)variableName);
                return null;
            }
            String variableValue = provider.get(variableName);
            if (StringUtils.isEmpty((CharSequence)variableValue) || Actions.isVariableValueInvalid(param, variableValue)) {
                logger.debug("Attribute {} was not validated with value {}.", (Object)attribute, (Object)variableValue);
                return null;
            }
            return new ParseStringAttributeDifference(param, variableValue);
        }
        return null;
    }

    public static boolean validateAction(Action action, ValueProvider provider) {
        return !Actions.isParameterizedAction(action, provider) || Actions.validateAction((ParameterizedAction)action, provider);
    }

    private static boolean validateAction(ParameterizedAction action, ValueProvider provider) {
        logger.debug("Validating parameterized action {}.", (Object)action);
        return Actions.validateActionParameters(action, provider) && Actions.validateElementAttributes(action, provider);
    }

    private static boolean validateActionParameters(ParameterizedAction action, ValueProvider provider) {
        Set<ActionParameter> parameters = action.getActionParameter();
        for (ActionParameter parameter : parameters) {
            String variableName = parameter.getVariableName();
            if (Actions.isVariableNameInvalid(variableName)) {
                logger.debug("ActionParameter {} was not validated with name {}.", (Object)parameter, (Object)variableName);
                continue;
            }
            String variableValue = provider.get(variableName);
            if (!StringUtils.isNotEmpty((CharSequence)variableValue) || !Actions.isVariableValueInvalid(parameter, variableValue)) continue;
            logger.debug("ActionParameter {} was not validated with value {}.", (Object)parameter, (Object)variableValue);
            return false;
        }
        return true;
    }

    private static boolean validateElementAttributes(ParameterizedAction action, ValueProvider provider) {
        IdentifyingAttributes attributes = action.getTargetElement().getIdentifyingAttributes();
        for (Attribute attribute : attributes.getAttributes()) {
            if (!(attribute instanceof ParameterizedAttribute)) continue;
            ParameterizedAttribute param = (ParameterizedAttribute)attribute;
            String variableName = param.getVariableName();
            if (Actions.isVariableNameInvalid(variableName)) {
                logger.debug("Attribute {} was not validated with name {}.", (Object)param, (Object)variableName);
                continue;
            }
            String variableValue = provider.get(variableName);
            if (!StringUtils.isNotEmpty((CharSequence)variableValue) || !Actions.isVariableValueInvalid(param, variableValue)) continue;
            logger.debug("Attribute {} was not validated with value {}.", (Object)param, (Object)variableValue);
            return false;
        }
        return true;
    }

    private static boolean isParameterizedAction(Action action, ValueProvider provider) {
        return provider != null && action instanceof ParameterizedAction;
    }

    private static boolean isVariableValueInvalid(ActionParameter parameter, String value) {
        return !ParameterType.getType(parameter.getType()).canParse(value);
    }

    private static boolean isVariableValueInvalid(ParameterizedAttribute attribute, String value) {
        return !attribute.getType().canParse(value);
    }

    private static boolean isVariableNameInvalid(String name) {
        return StringUtils.isEmpty((CharSequence)name);
    }
}

