/*
 * Decompiled with CFR 0.152.
 */
package de.retest.recheck.ui.actions;

import de.retest.recheck.util.ChecksumCalculator;
import de.retest.recheck.util.ExceptionUtil;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlTransient;
import java.io.Serializable;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class ExceptionWrapper
implements Serializable {
    private static final long serialVersionUID = 1L;
    @XmlAttribute
    private final String errorId;
    @XmlAttribute
    private final String type;
    @XmlElement
    private final String stacktrace;
    @XmlElement
    private final String errorMsg;
    @XmlTransient
    private transient Throwable throwable;
    @XmlElement
    private final String errorLocation;

    private ExceptionWrapper() {
        this.errorId = null;
        this.type = null;
        this.stacktrace = null;
        this.errorMsg = null;
        this.errorLocation = null;
    }

    public ExceptionWrapper(Throwable throwable) {
        assert (throwable != null);
        this.throwable = throwable;
        Throwable deepestCause = ExceptionUtil.getDeepestCause(throwable);
        this.type = deepestCause.getClass().getName();
        this.errorMsg = deepestCause.getMessage();
        this.errorLocation = ExceptionUtil.getDeepestStackTraceElement(deepestCause);
        this.errorId = ChecksumCalculator.getInstance().sha256(this.toString());
        this.stacktrace = ExceptionUtil.getStackTrace(throwable);
    }

    public ExceptionWrapper(String type, String stacktrace, String errorMsg, String errorLocation) {
        this.type = type;
        this.stacktrace = stacktrace;
        this.errorMsg = errorMsg;
        this.errorLocation = errorLocation;
        this.errorId = ChecksumCalculator.getInstance().sha256(this.toString());
    }

    public Throwable getThrowable() {
        return this.throwable;
    }

    public String getStackTrace() {
        return this.stacktrace;
    }

    public String getMessage() {
        return this.errorMsg;
    }

    public String getType() {
        return this.type;
    }

    public String toString() {
        StringBuilder result = new StringBuilder().append(this.type);
        if (this.errorMsg != null && !this.errorMsg.trim().isEmpty()) {
            result.append(": ").append(this.errorMsg);
        }
        if (this.errorLocation != null && !this.errorLocation.trim().isEmpty()) {
            result.append(" at ").append(this.errorLocation);
        }
        return result.toString();
    }
}

