/*
 * Decompiled with CFR 0.152.
 */
package de.retest.recheck.ui.descriptors;

import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.io.Serializable;

@XmlRootElement
public abstract class Attribute
implements Serializable,
Comparable<Attribute> {
    private static final long serialVersionUID = 1L;
    public static final double IGNORE_WEIGHT = Double.MIN_NORMAL;
    public static final double NORMAL_WEIGHT = 1.0;
    public static final double FULL_MATCH = 1.0;
    public static final double NO_MATCH = 0.0;
    public static final int COMPARE_BIGGER = 1;
    public static final int COMPARE_EQUAL = 0;
    public static final int COMPARE_SMALLER = -1;
    @XmlAttribute
    private final String key;

    protected Attribute() {
        this.key = null;
    }

    protected Attribute(String key) {
        assert (key != null) : "Key may not be null!";
        this.key = key;
    }

    public final String getKey() {
        return this.key;
    }

    public final int hashCode() {
        return this.key.hashCode() + 31 * (this.getValue() == null ? 0 : this.getValue().hashCode());
    }

    public final boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Attribute)) {
            return false;
        }
        Attribute other = (Attribute)obj;
        if (!this.key.equals(other.key)) {
            return false;
        }
        return !(this.getValue() == null ? other.getValue() != null : !this.getValue().equals(other.getValue()));
    }

    public String toString() {
        return "Attribute [key=" + this.key + ", value=" + this.getValue() + "]";
    }

    public abstract Serializable getValue();

    public abstract double match(Attribute var1);

    public abstract Attribute applyChanges(Serializable var1);

    public double getWeight() {
        return 1.0;
    }

    public boolean isVisible() {
        return true;
    }

    public final boolean isNotVisible() {
        return !this.isVisible();
    }

    @Override
    public int compareTo(Attribute other) {
        if (other == null) {
            return 1;
        }
        if (!this.getKey().equals(other.getKey())) {
            return this.getKey().compareTo(other.getKey());
        }
        if (this.getValue() == null) {
            if (other.getValue() == null) {
                return 0;
            }
            return -1;
        }
        if (other.getValue() == null) {
            return 1;
        }
        return this.getValue().toString().compareTo(other.getValue().toString());
    }
}

