/*
 * Decompiled with CFR 0.152.
 */
package de.retest.recheck.ui.descriptors;

import de.retest.recheck.ui.descriptors.IdentifyingAttributes;
import de.retest.recheck.ui.descriptors.OutlineAttribute;
import de.retest.recheck.ui.diff.AttributeDifference;
import de.retest.recheck.ui.diff.ElementDifference;
import de.retest.recheck.ui.diff.IdentifyingAttributesDifference;
import java.awt.Rectangle;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AttributeUtil {
    private static final Logger log = LoggerFactory.getLogger(AttributeUtil.class);

    private AttributeUtil() {
    }

    public static Rectangle getActualOutline(ElementDifference difference) {
        Rectangle actualRelative = AttributeUtil.getActualOutline(difference, "outline");
        if (actualRelative != null) {
            return actualRelative;
        }
        return AttributeUtil.getOutline(difference.getIdentifyingAttributes());
    }

    public static Rectangle getActualAbsoluteOutline(ElementDifference difference) {
        Rectangle actualAbsolute = AttributeUtil.getActualOutline(difference, "absolute-outline");
        if (actualAbsolute != null) {
            return actualAbsolute;
        }
        return AttributeUtil.getAbsoluteOutline(difference.getIdentifyingAttributes());
    }

    public static Rectangle getOutline(IdentifyingAttributes attributes) {
        OutlineAttribute outlineAttribute = (OutlineAttribute)attributes.getAttribute("outline");
        if (outlineAttribute == null) {
            return null;
        }
        return outlineAttribute.getValue();
    }

    public static Rectangle getAbsoluteOutline(ElementDifference difference) {
        return AttributeUtil.getAbsoluteOutline(difference.getIdentifyingAttributes());
    }

    public static Rectangle getAbsoluteOutline(IdentifyingAttributes attributes) {
        OutlineAttribute outlineAttribute = (OutlineAttribute)attributes.getAttribute("absolute-outline");
        if (outlineAttribute == null) {
            return null;
        }
        return outlineAttribute.getValue();
    }

    static Rectangle getActualOutline(ElementDifference difference, String type) {
        List<AttributeDifference> attributeDifferences;
        if (!(difference.getIdentifyingAttributesDifference() instanceof IdentifyingAttributesDifference)) {
            log.error("getIdentifyingAttributesDifference should return an IdentifyingAttributesDifference!");
            return difference.getElement().getIdentifyingAttributes().getOutlineRectangle();
        }
        IdentifyingAttributesDifference identifyingAttributesDifference = (IdentifyingAttributesDifference)difference.getIdentifyingAttributesDifference();
        if (identifyingAttributesDifference != null && (attributeDifferences = identifyingAttributesDifference.getAttributeDifferences()) != null) {
            for (AttributeDifference aDiff : attributeDifferences) {
                if (!aDiff.getKey().equals(type)) continue;
                return (Rectangle)aDiff.getActual();
            }
        }
        return null;
    }
}

