/*
 * Decompiled with CFR 0.152.
 */
package de.retest.recheck.ui.descriptors;

import de.retest.recheck.ui.descriptors.Element;
import java.util.ArrayList;
import java.util.List;

public class ElementUtil {
    private ElementUtil() {
    }

    public static List<Element> flattenAllElements(List<? extends Element> elements) {
        ArrayList<Element> flattened = new ArrayList<Element>();
        for (Element element : elements) {
            flattened.add(element);
            flattened.addAll(ElementUtil.flattenChildElements(element));
        }
        return flattened;
    }

    public static List<Element> flattenChildElements(Element element) {
        ArrayList<Element> flattened = new ArrayList<Element>();
        for (Element childElement : element.getContainedElements()) {
            flattened.add(childElement);
            flattened.addAll(ElementUtil.flattenChildElements(childElement));
        }
        return flattened;
    }

    public static boolean pathEquals(Element element0, Element element1) {
        return element0.getIdentifyingAttributes().getPathTyped().equals(element1.getIdentifyingAttributes().getPathTyped());
    }

    public static boolean retestIdEquals(Element element0, Element element1) {
        return element0.getRetestId().equals(element1.getRetestId());
    }
}

