/*
 * Decompiled with CFR 0.152.
 */
package de.retest.recheck.ui.descriptors;

import de.retest.recheck.persistence.DateAdapter;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Objects;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class GroundState
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String PROPERTY_EXECUTION_DATE = "de.retest.execution.Date";
    public static final String PROPERTY_EXECUTION_SEED = "de.retest.execution.randomSeed";
    public static final String UNSPECIFIED = "unspecified SUT version";
    private final transient SimpleDateFormat xmlDateFormat = new SimpleDateFormat("dd.MM.yyyy-HH:mm:ss:SSS");
    @XmlElement
    protected final String sutVersion;
    @XmlElement
    @XmlJavaTypeAdapter(value=DateAdapter.class)
    protected final Date executionDate;
    @XmlElement
    protected final long randomSeed;

    public GroundState() {
        this(UNSPECIFIED);
    }

    public GroundState(String sutVersion) {
        this.sutVersion = sutVersion;
        this.executionDate = this.getDateProperty();
        this.randomSeed = this.getRandomSeedProperty();
    }

    private long getRandomSeedProperty() {
        String property = System.getProperty(PROPERTY_EXECUTION_SEED);
        if (property == null) {
            long result = 1L;
            System.setProperty(PROPERTY_EXECUTION_SEED, Long.toString(1L));
            return 1L;
        }
        return Long.parseLong(property);
    }

    private Date getDateProperty() {
        String property = System.getProperty(PROPERTY_EXECUTION_DATE);
        if (property == null) {
            Date result = new Date();
            System.setProperty(PROPERTY_EXECUTION_DATE, this.xmlDateFormat.format(result));
            return result;
        }
        try {
            return this.xmlDateFormat.parse(property);
        }
        catch (ParseException exc) {
            throw new RuntimeException("Exception parsing date '" + property + "'.", exc);
        }
    }

    public GroundState(String sutVersion, Date executionDate, long randomSeed) {
        this.sutVersion = sutVersion;
        this.executionDate = executionDate;
        this.randomSeed = randomSeed;
    }

    public Date getExecutionDate() {
        return this.executionDate;
    }

    public long getRandomSeed() {
        return this.randomSeed;
    }

    public int hashCode() {
        return Objects.hash(this.executionDate, this.randomSeed, this.sutVersion);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        GroundState other = (GroundState)obj;
        return Objects.equals(this.executionDate, other.executionDate) && this.randomSeed == other.randomSeed && Objects.equals(this.sutVersion, other.sutVersion);
    }

    public String toString() {
        String date = this.xmlDateFormat.format(this.executionDate);
        return "GroundState[sutVersion=" + this.sutVersion + ", executionDate=" + date + ", randomSeed=" + this.randomSeed + "l]";
    }

    public String getSutVersion() {
        return this.sutVersion;
    }
}

