/*
 * Decompiled with CFR 0.152.
 */
package de.retest.recheck.ui.descriptors;

import de.retest.recheck.ignore.GloballyIgnoredAttributes;
import de.retest.recheck.ui.Path;
import de.retest.recheck.ui.PathElement;
import de.retest.recheck.ui.descriptors.Attribute;
import de.retest.recheck.ui.descriptors.AttributesAdapter;
import de.retest.recheck.ui.descriptors.DefaultAttribute;
import de.retest.recheck.ui.descriptors.OutlineAttribute;
import de.retest.recheck.ui.descriptors.PathAttribute;
import de.retest.recheck.ui.descriptors.StringAttribute;
import de.retest.recheck.ui.descriptors.SuffixAttribute;
import de.retest.recheck.ui.diff.AttributeDifference;
import de.retest.recheck.util.ChecksumCalculator;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.awt.Rectangle;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.stream.Collectors;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class IdentifyingAttributes
implements Serializable,
Comparable<IdentifyingAttributes> {
    public static final String PATH_ATTRIBUTE_KEY = "path";
    public static final String TYPE_ATTRIBUTE_KEY = "type";
    private static final List<String> identifyingAttributes = Collections.unmodifiableList(Arrays.asList("path", "type", "name", "text", "codeLoc", "x", "y", "height", "width", "context"));
    public static final double PERFECT_SIMILARITY = 3.0;
    private static final long serialVersionUID = 1L;
    @XmlElement
    @XmlJavaTypeAdapter(value=AttributesAdapter.class)
    private final SortedMap<String, Attribute> attributes = new TreeMap<String, Attribute>();
    private transient String parentPathCache;

    protected IdentifyingAttributes() {
    }

    public IdentifyingAttributes(Collection<Attribute> attributes) {
        for (Attribute attribute : attributes) {
            this.attributes.put(attribute.getKey(), attribute);
        }
    }

    public static List<Attribute> createList(Path path, String type) {
        if (type == null) {
            throw new NullPointerException("Type must not be null.");
        }
        if ((type = type.trim()).isEmpty()) {
            throw new IllegalArgumentException("Type must not be empty.");
        }
        return new ArrayList<Attribute>(Arrays.asList(new PathAttribute(path), new StringAttribute(TYPE_ATTRIBUTE_KEY, type), new SuffixAttribute(path.getElement().getSuffix())));
    }

    public static IdentifyingAttributes create(Path path, Class<?> type) {
        return IdentifyingAttributes.create(path, type.getName());
    }

    public static IdentifyingAttributes create(Path path, String type) {
        return new IdentifyingAttributes(IdentifyingAttributes.createList(path, type));
    }

    public String getType() {
        return (String)this.get(TYPE_ATTRIBUTE_KEY);
    }

    public OutlineAttribute getOutline() {
        return (OutlineAttribute)this.getAttribute("outline");
    }

    public Rectangle getOutlineRectangle() {
        OutlineAttribute outlineAttribute = this.getOutline();
        if (outlineAttribute == null) {
            return null;
        }
        return outlineAttribute.getValue();
    }

    public String getSimpleType() {
        return this.getType().substring(this.getType().lastIndexOf(46) + 1);
    }

    public String getPath() {
        return this.getPathTyped().toString();
    }

    public Path getPathTyped() {
        return ((PathAttribute)this.attributes.get(PATH_ATTRIBUTE_KEY)).getValue();
    }

    public String getParentPath() {
        if (this.parentPathCache == null) {
            this.parentPathCache = this.getPathTyped().getParentPath() == null ? "" : this.getPathTyped().getParentPath().toString();
        }
        return this.parentPathCache;
    }

    public Path getParentPathTyped() {
        return this.getPathTyped().getParentPath();
    }

    public PathElement getPathElement() {
        return this.getPathTyped().getElement();
    }

    public String toFullString() {
        return this.getValuesForFullString().stream().filter(Objects::nonNull).collect(Collectors.joining(" # "));
    }

    public String identifier() {
        return ChecksumCalculator.getInstance().sha256(this.toFullString());
    }

    protected List<String> getValuesForFullString() {
        return Arrays.asList(this.getParentPath(), this.getType(), this.getSuffix());
    }

    @Override
    public int compareTo(IdentifyingAttributes other) {
        for (Attribute attribute : this.attributes.values()) {
            int result = attribute.compareTo(other.getAttribute(attribute.getKey()));
            if (result == 0) continue;
            return result;
        }
        return 0;
    }

    public double match(IdentifyingAttributes other) {
        double result = 0.0;
        double unifyingFactor = 0.0;
        HashSet<Attribute> otherAttributes = new HashSet<Attribute>(other.attributes.values());
        for (Attribute attribute : this.attributes.values()) {
            Attribute otherAttribute = other.getAttribute(attribute.getKey());
            otherAttributes.remove(otherAttribute);
            if (GloballyIgnoredAttributes.getInstance().shouldIgnoreAttribute(attribute.getKey())) continue;
            unifyingFactor += attribute.getWeight();
            if (otherAttribute == null) continue;
            result += attribute.getWeight() * attribute.match(otherAttribute);
        }
        for (Attribute attribute : otherAttributes) {
            unifyingFactor += attribute.getWeight();
        }
        if (unifyingFactor == 0.0) {
            throw new ArithmeticException("Cannot divide with a unifying factor of 0.0");
        }
        assert ((result /= unifyingFactor) >= 0.0 && result <= 1.0) : "Match result " + result + " should be in [0,1].";
        return result;
    }

    public String toString() {
        String text;
        String type = this.getType();
        if (type == null) {
            return "";
        }
        String result = type;
        if (type.lastIndexOf(46) > -1) {
            result = type.substring(type.lastIndexOf(46) + 1);
        }
        if ((text = (String)this.get("text")) != null) {
            return result + " [" + text + "]";
        }
        String id = (String)this.get("id");
        if (id != null) {
            return result + " [" + id + "]";
        }
        String name = (String)this.get("name");
        if (name != null) {
            return result + " [" + name + "]";
        }
        return this.getPath();
    }

    public String getSuffix() {
        return (String)this.get("suffix");
    }

    public <T> T get(String key) {
        Attribute attribute = (Attribute)this.attributes.get(key);
        if (attribute == null) {
            return null;
        }
        Serializable value = attribute.getValue();
        return (T)value;
    }

    public String getContext() {
        return (String)this.get("context");
    }

    public IdentifyingAttributes applyChanges(Set<AttributeDifference> attributeChanges) {
        if (attributeChanges.isEmpty()) {
            return this;
        }
        HashMap<String, Attribute> newAttributes = new HashMap<String, Attribute>(this.attributes);
        for (AttributeDifference attributeDifference : attributeChanges) {
            String key = attributeDifference.getKey();
            Attribute attribute = (Attribute)this.attributes.get(key);
            if (attribute == null) {
                Serializable actual = attributeDifference.getActual();
                if (actual instanceof Attribute) {
                    newAttributes.put(key, (Attribute)actual);
                    continue;
                }
                newAttributes.put(key, new DefaultAttribute(key, actual));
                continue;
            }
            newAttributes.put(key, attributeDifference.applyChangeTo(attribute));
        }
        return this.newInstance(newAttributes.values());
    }

    protected IdentifyingAttributes newInstance(Collection<Attribute> attributes) {
        return new IdentifyingAttributes(attributes);
    }

    public Attribute getAttribute(String key) {
        return (Attribute)this.attributes.get(key);
    }

    public List<Attribute> getAttributes() {
        ArrayList<Attribute> result = new ArrayList<Attribute>(this.attributes.values());
        Collections.sort(result);
        return result;
    }

    public static boolean isIdentifyingAttribute(String key) {
        return identifyingAttributes.contains(key);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof IdentifyingAttributes)) {
            return false;
        }
        IdentifyingAttributes other = (IdentifyingAttributes)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<Attribute> this$attributes = this.getAttributes();
        List<Attribute> other$attributes = other.getAttributes();
        return !(this$attributes == null ? other$attributes != null : !((Object)this$attributes).equals(other$attributes));
    }

    protected boolean canEqual(Object other) {
        return other instanceof IdentifyingAttributes;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<Attribute> $attributes = this.getAttributes();
        result = result * 59 + ($attributes == null ? 43 : ((Object)$attributes).hashCode());
        return result;
    }
}

