/*
 * Decompiled with CFR 0.152.
 */
package de.retest.recheck.ui.descriptors;

import de.retest.recheck.ui.Path;
import de.retest.recheck.ui.PathAdapter;
import de.retest.recheck.ui.descriptors.Attribute;
import de.retest.recheck.ui.descriptors.ParameterParseException;
import de.retest.recheck.ui.descriptors.ParameterType;
import de.retest.recheck.ui.descriptors.ParameterizedAttribute;
import de.retest.recheck.util.ObjectUtil;
import de.retest.recheck.util.StringSimilarity;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlValue;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.io.Serializable;
import org.eclipse.persistence.oxm.annotations.XmlValueExtension;

@XmlRootElement
public class PathAttribute
extends ParameterizedAttribute {
    public static final ParameterType parameterTypePath = new ParameterType("PATH"){

        @Override
        public Object parse(String value) throws ParameterParseException {
            try {
                return Path.fromString(value);
            }
            catch (Exception e) {
                throw new ParameterParseException("Value must be a valid and parsable path.", e);
            }
        }
    };
    private static final long serialVersionUID = 1L;
    public static final String PATH_KEY = "path";
    @XmlValue
    @XmlValueExtension
    @XmlJavaTypeAdapter(value=PathAdapter.class)
    private final Path path;

    protected PathAttribute() {
        this.path = null;
    }

    public PathAttribute(Path path) {
        this(path, null);
    }

    public PathAttribute(Path path, String variableName) {
        super(PATH_KEY, variableName);
        ObjectUtil.checkNull(path, PATH_KEY);
        this.path = path;
    }

    @Override
    public Path getValue() {
        return this.path;
    }

    @Override
    public double match(Attribute other) {
        if (!(other instanceof PathAttribute) || !PATH_KEY.equals(other.getKey())) {
            return 0.0;
        }
        String parentPath = this.getValue().getParentPath() == null ? "" : this.getValue().getParentPath().toString();
        Path otherPath = ((PathAttribute)other).getValue();
        String otherParentPath = otherPath.getParentPath() == null ? "" : otherPath.getParentPath().toString();
        return StringSimilarity.pathSimilarity(parentPath, otherParentPath);
    }

    @Override
    public Attribute applyChanges(Serializable actual) {
        if (actual instanceof String) {
            return new PathAttribute(Path.fromString((String)((Object)actual)), this.getVariableName());
        }
        return new PathAttribute((Path)actual, this.getVariableName());
    }

    @Override
    public ParameterizedAttribute applyVariableChange(String variableName) {
        return new PathAttribute(this.getValue(), variableName);
    }

    @Override
    public ParameterType getType() {
        return parameterTypePath;
    }
}

