/*
 * Decompiled with CFR 0.152.
 */
package de.retest.recheck.ui.descriptors;

import de.retest.recheck.ui.descriptors.Attributes;
import de.retest.recheck.ui.descriptors.Element;
import de.retest.recheck.ui.descriptors.IdentifyingAttributes;
import de.retest.recheck.ui.image.Screenshot;
import de.retest.recheck.ui.review.ActionChangeSet;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.util.ArrayList;
import java.util.List;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class RootElement
extends Element {
    private static final long serialVersionUID = 2L;
    @XmlAttribute
    private final int screenId;
    @XmlAttribute
    private final String screen;
    @XmlAttribute
    private final String title;

    private RootElement() {
        this.screenId = 0;
        this.screen = null;
        this.title = null;
    }

    public RootElement(String retestId, IdentifyingAttributes identifyingAttributes, Attributes attributes, Screenshot screenshot, String screen, int screenId, String title) {
        super(retestId, null, identifyingAttributes, attributes, screenshot);
        this.screen = screen;
        this.screenId = screenId;
        this.title = title;
    }

    public String getScreen() {
        return this.screen;
    }

    public int getScreenId() {
        return this.screenId;
    }

    public String getTitle() {
        return this.title;
    }

    public static List<Screenshot> getScreenshots(List<RootElement> windows) {
        ArrayList<Screenshot> result = new ArrayList<Screenshot>();
        for (RootElement rootElement : windows) {
            result.add(rootElement.getScreenshot());
        }
        return result;
    }

    @Override
    public RootElement applyChanges(ActionChangeSet actionChangeSet) {
        if (actionChangeSet == null) {
            return this;
        }
        IdentifyingAttributes newIdentAttributes = this.identifyingAttributes.applyChanges(actionChangeSet.getIdentAttributeChanges().getAll(this.identifyingAttributes));
        Attributes newAttributes = this.attributes.applyChanges(actionChangeSet.getAttributesChanges().getAll(this.identifyingAttributes));
        Screenshot newScreenshot = actionChangeSet.getScreenshot().getScreenshot(this.identifyingAttributes);
        List<Element> newContainedElements = this.createNewElementList(actionChangeSet, newIdentAttributes);
        RootElement rootElement = new RootElement(this.retestId, newIdentAttributes, newAttributes, newScreenshot, this.screen, this.screenId, this.title);
        rootElement.addChildren(newContainedElements);
        return rootElement;
    }

    @Override
    public String toString() {
        if (this.title != null) {
            return this.title;
        }
        return super.toString();
    }
}

