/*
 * Decompiled with CFR 0.152.
 */
package de.retest.recheck.ui.descriptors;

import de.retest.recheck.ui.diff.AttributeDifference;
import de.retest.recheck.ui.image.Screenshot;
import de.retest.recheck.util.ObjectUtil;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.io.Serializable;
import java.util.Locale;
import java.util.Objects;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class ScreenshotAttributeDifference
extends AttributeDifference {
    private static final long serialVersionUID = 1L;
    @XmlAttribute
    private final String strategyName;
    @XmlAttribute
    private final double match;

    private ScreenshotAttributeDifference() {
        this.strategyName = null;
        this.match = 0.0;
    }

    public ScreenshotAttributeDifference(Screenshot expected, Screenshot actual, String strategyName, double match) {
        super("screenshot", expected, actual);
        this.strategyName = strategyName;
        this.match = match;
    }

    public String getStrategyName() {
        return this.strategyName;
    }

    public double getMatch() {
        return this.match;
    }

    @Override
    public int hashCode() {
        return ObjectUtil.nextHashCode(ObjectUtil.nextHashCode(super.hashCode(), (Serializable)((Object)this.strategyName)), Double.valueOf(this.match));
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ScreenshotAttributeDifference other = (ScreenshotAttributeDifference)obj;
        return Objects.equals(this.getKey(), other.getKey()) && Objects.equals(this.getExpected(), other.getExpected()) && Objects.equals(this.getActual(), other.getActual()) && Objects.equals(this.getStrategyName(), other.getStrategyName());
    }

    @Override
    public String toString() {
        return this.getKey() + " = [expected=" + this.getExpected() + ", actual=" + this.getActual() + ", " + this.strategyName + " found " + String.format(Locale.ENGLISH, "%.2f%%", 100.0 * this.match) + " match]";
    }
}

