/*
 * Decompiled with CFR 0.152.
 */
package de.retest.recheck.ui.descriptors;

import de.retest.recheck.ui.descriptors.Attribute;
import de.retest.recheck.ui.descriptors.ParameterParseException;
import de.retest.recheck.ui.descriptors.ParameterType;
import de.retest.recheck.ui.descriptors.ParameterizedAttribute;
import de.retest.recheck.util.StringSimilarity;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlValue;
import java.io.Serializable;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.persistence.oxm.annotations.XmlValueExtension;

@XmlRootElement
public class StringAttribute
extends ParameterizedAttribute {
    public static final ParameterType parameterTypeString = new ParameterType("STRING"){

        @Override
        public String parse(String value) {
            return value;
        }
    };
    public static final ParameterType parameterTypeClass = new ParameterType("CLASS_NAME"){

        @Override
        public Class<?> parse(String value) throws ParameterParseException {
            try {
                return Class.forName(value);
            }
            catch (Exception e) {
                throw new ParameterParseException("Value must be a fully qualified class on the classpath.", e);
            }
        }
    };
    public static final ParameterType parameterTypeInteger = new ParameterType("INTEGER"){

        @Override
        public Integer parse(String value) throws ParameterParseException {
            try {
                return Integer.parseInt(value);
            }
            catch (Exception e) {
                throw new ParameterParseException("Value must be a valid integer.", e);
            }
        }
    };
    public static final ParameterType parameterTypeBoolean = new ParameterType("BOOLEAN"){

        @Override
        public Boolean parse(String value) throws ParameterParseException {
            if ("true".equalsIgnoreCase(value)) {
                return Boolean.TRUE;
            }
            if ("false".equalsIgnoreCase(value)) {
                return Boolean.FALSE;
            }
            throw new ParameterParseException("Value must be 'true' or 'false' (ignoring case).", new IllegalArgumentException());
        }
    };
    private static final long serialVersionUID = 1L;
    @XmlValue
    @XmlValueExtension
    private final String value;

    protected StringAttribute() {
        this.value = null;
    }

    public StringAttribute(String key, String value) {
        this(key, value, null);
    }

    public StringAttribute(String key, String value, String variableName) {
        super(key, variableName);
        this.value = StringAttribute.escape(value);
    }

    private static String escape(String value) {
        if (value == null) {
            return value;
        }
        return value.replace("]]>", "]]&gt;");
    }

    public String getValue() {
        if (StringUtils.isEmpty((CharSequence)this.value)) {
            return null;
        }
        return this.value;
    }

    @Override
    public double match(Attribute other) {
        if (!(other instanceof StringAttribute) || !other.getKey().equals(this.getKey())) {
            return 0.0;
        }
        return StringSimilarity.simpleSimilarity(this.getValue(), ((StringAttribute)other).getValue());
    }

    @Override
    public Attribute applyChanges(Serializable actual) {
        return new StringAttribute(this.getKey(), (String)((Object)actual), this.getVariableName());
    }

    @Override
    public ParameterizedAttribute applyVariableChange(String variableName) {
        return new StringAttribute(this.getKey(), this.getValue(), variableName);
    }

    @Override
    public ParameterType getType() {
        return parameterTypeString;
    }
}

