/*
 * Decompiled with CFR 0.152.
 */
package de.retest.recheck.ui.descriptors;

import de.retest.recheck.meta.MetadataProvider;
import de.retest.recheck.persistence.Persistable;
import de.retest.recheck.ui.descriptors.Element;
import de.retest.recheck.ui.descriptors.RootElement;
import de.retest.recheck.ui.review.ActionChangeSet;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class SutState
extends Persistable {
    private static final long serialVersionUID = 1L;
    private static final int PERSISTENCE_VERSION = 4;
    @XmlElement
    private final List<RootElement> descriptors;
    @XmlElement
    private final Map<String, String> metadata;

    private SutState() {
        super(4);
        this.descriptors = new ArrayList<RootElement>();
        this.metadata = new HashMap<String, String>();
    }

    public SutState(Collection<RootElement> set) {
        this(set, MetadataProvider.empty());
    }

    public SutState(Collection<RootElement> set, MetadataProvider metadata) {
        super(4);
        if (set == null) {
            throw new NullPointerException();
        }
        this.descriptors = new ArrayList<RootElement>(set);
        this.metadata = new HashMap<String, String>(metadata.retrieve());
    }

    public List<RootElement> getRootElements() {
        return this.descriptors;
    }

    public Map<String, String> getMetadata() {
        return Collections.unmodifiableMap(this.metadata);
    }

    public String getMetadata(String key) {
        return this.metadata.get(key);
    }

    public int hashCode() {
        return this.descriptors.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof SutState)) {
            return false;
        }
        SutState other = (SutState)obj;
        return this.descriptors.equals(other.descriptors);
    }

    public String toString() {
        return "State" + this.descriptors;
    }

    public SutState applyChanges(ActionChangeSet actionChangeSet) {
        if (actionChangeSet == null) {
            return this;
        }
        ArrayList<RootElement> descriptors = new ArrayList<RootElement>();
        for (RootElement rootElement : this.getRootElements()) {
            descriptors.add(rootElement.applyChanges(actionChangeSet));
        }
        for (Element element : actionChangeSet.getInsertedChanges()) {
            if (!(element instanceof RootElement)) continue;
            descriptors.add((RootElement)element);
        }
        HashMap<String, String> newMetadata = new HashMap<String, String>(this.metadata);
        newMetadata.putAll(actionChangeSet.getMetadata());
        return new SutState(descriptors, () -> newMetadata);
    }
}

