/*
 * Decompiled with CFR 0.152.
 */
package de.retest.recheck.ui.descriptors;

import de.retest.recheck.ignore.Filter;
import de.retest.recheck.ui.descriptors.Attribute;
import de.retest.recheck.ui.descriptors.Attributes;
import de.retest.recheck.ui.descriptors.Element;
import de.retest.recheck.ui.descriptors.IdentifyingAttributes;
import de.retest.recheck.ui.descriptors.MutableAttributes;
import de.retest.recheck.ui.descriptors.RootElement;
import de.retest.recheck.ui.descriptors.SutState;
import de.retest.recheck.ui.image.Screenshot;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

public class SutStateFilter {
    private final Filter filter;

    public SutState filter(SutState sutState) {
        if (this.filterNothing()) {
            return sutState;
        }
        List<RootElement> rootElements = sutState.getRootElements();
        List<RootElement> filteredRootElements = rootElements.stream().map(this::filter).collect(Collectors.toList());
        return new SutState(filteredRootElements, sutState::getMetadata);
    }

    public RootElement filter(RootElement rootElement) {
        if (this.filterNothing()) {
            return rootElement;
        }
        IdentifyingAttributes newIdentifyingAttributes = this.filter((Element)rootElement, rootElement.getIdentifyingAttributes());
        Attributes newAttributes = this.filter((Element)rootElement, rootElement.getAttributes());
        String retestId = rootElement.getRetestId();
        Screenshot screenshot = rootElement.getScreenshot();
        String screen = rootElement.getScreen();
        int screenId = rootElement.getScreenId();
        String title = rootElement.getTitle();
        List<Element> containedElements = rootElement.getContainedElements();
        RootElement newRootElement = new RootElement(retestId, newIdentifyingAttributes, newAttributes, screenshot, screen, screenId, title);
        List<Element> newContainedElements = this.filterContainedElements(newRootElement, containedElements);
        newRootElement.addChildren(newContainedElements);
        return newRootElement;
    }

    IdentifyingAttributes filter(Element element, IdentifyingAttributes identifyingAttributes) {
        List<Attribute> attributes = identifyingAttributes.getAttributes();
        List<Attribute> filteredAttributes = attributes.stream().filter((? super T attribute) -> !this.filter.matches(element, attribute.getKey())).collect(Collectors.toList());
        return new IdentifyingAttributes(filteredAttributes);
    }

    Attributes filter(Element element, Attributes attributes) {
        MutableAttributes filteredAttributes = new MutableAttributes();
        StreamSupport.stream(attributes.spliterator(), false).filter((? super T attribute) -> !this.filter.matches(element, (String)attribute.getKey())).forEach(attribute -> filteredAttributes.put((String)attribute.getKey(), (String)attribute.getValue()));
        return filteredAttributes.immutable();
    }

    private Element filter(Element element, Element parent) {
        IdentifyingAttributes newIdentifyingAttributes = this.filter(element, element.getIdentifyingAttributes());
        Attributes newAttributes = this.filter(element, element.getAttributes());
        String retestId = element.getRetestId();
        List<Element> containedElements = element.getContainedElements();
        Element newElement = Element.create(retestId, parent, newIdentifyingAttributes, newAttributes);
        List<Element> newContainedElements = this.filterContainedElements(newElement, containedElements);
        newElement.addChildren(newContainedElements);
        return newElement;
    }

    private List<Element> filterContainedElements(Element newParent, List<Element> containedElements) {
        return containedElements.stream().map(element -> this.filter((Element)element, newParent)).collect(Collectors.toList());
    }

    private boolean filterNothing() {
        return this.filter == Filter.NEVER_MATCH;
    }

    public SutStateFilter(Filter filter) {
        this.filter = filter;
    }
}

