/*
 * Decompiled with CFR 0.152.
 */
package de.retest.recheck.ui.descriptors.idproviders;

import de.retest.recheck.ui.descriptors.IdentifyingAttributes;
import de.retest.recheck.ui.descriptors.idproviders.RetestIdProvider;
import de.retest.recheck.util.RetestIdUtil;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;

abstract class AbstractFirstNonNullRetestIdProvider
implements RetestIdProvider {
    protected static final String DELIMITER = "-";

    AbstractFirstNonNullRetestIdProvider() {
    }

    @Override
    public String getRetestId(IdentifyingAttributes identifyingAttributes) {
        if (identifyingAttributes == null) {
            throw new NullPointerException("Identifying attributes must not be null.");
        }
        String text = RetestIdUtil.normalizeAndCut((String)identifyingAttributes.get("text"));
        String htmlId = RetestIdUtil.normalizeAndCut((String)identifyingAttributes.get("id"));
        String name = RetestIdUtil.normalizeAndCut((String)identifyingAttributes.get("name"));
        String type = RetestIdUtil.normalizeAndCut(RetestIdUtil.cutTypeQualifier((String)identifyingAttributes.get("type")));
        String id = this.returnFirstNonBlank(text, htmlId, name, type, UUID.randomUUID().toString());
        return this.makeUnique(id);
    }

    private String returnFirstNonBlank(String ... args) {
        for (String arg : args) {
            if (!StringUtils.isNotBlank((CharSequence)arg)) continue;
            return arg;
        }
        throw new IllegalStateException("Should have at least one non-blank argument!");
    }

    protected abstract String makeUnique(String var1);
}

